/*
 * Decompiled with CFR 0.152.
 */
package ua.gov.sfs.kpp.cbsender;

import com.google.devtools.common.options.OptionsParser;
import java.awt.EventQueue;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import ua.gov.sfs.kpp.cbsender.Config;
import ua.gov.sfs.kpp.cbsender.MainOptions;
import ua.gov.sfs.kpp.cbsender.Sender;
import ua.gov.sfs.kpp.cbsender.Start;

public class Main {
    public static void main(String[] args) throws Exception {
        OptionsParser parser = OptionsParser.newOptionsParser(MainOptions.class);
        parser.parseAndExitUponError(args);
        final MainOptions options = parser.getOptions(MainOptions.class);
        String wDir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        Config c = new Config();
        c.loadConfig(options);
        if (!options.console) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(Start.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Start.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Start.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(Start.class.getName()).log(Level.SEVERE, null, ex);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Start(options).setVisible(true);
                }
            });
        } else {
            if (options.files.isEmpty() && options.id.isEmpty()) {
                System.out.println("\t--file [-f] or --id required ");
                Main.printUsage(parser);
                return;
            }
            if (options.pkd.isEmpty() || options.ppd.isEmpty()) {
                System.out.println("\t--pkd and --ppd required ");
                Main.printUsage(parser);
                return;
            }
            Sender send = new Sender();
            send.send(options, wDir, null);
        }
    }

    private static void printUsage(OptionsParser parser) {
        System.out.println("Usage: java -jar sender.jar OPTIONS");
        System.out.println(parser.describeOptions(Collections.emptyMap(), OptionsParser.HelpVerbosity.LONG));
    }
}

