/*
 * Decompiled with CFR 0.152.
 */
package ua.gov.sfs.kpp.cbsender;

import com.iit.certificateAuthority.endUser.libraries.signJava.EndUser;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCMPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCertificateInfoEx;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserException;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserFileStoreSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserLDAPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserModeSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOCSPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOwnerInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserPrivateKeyInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserProxySettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSenderInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSignInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserTSPSettings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import ua.gov.sfs.kpp.cbsender.Utils;

public class Crypt {
    public static String CONST_SIGN = "UA1_SIGN\u0000";
    public static String CONST_TR = "TRANSPORTABLE\u0000";
    public static String CONST_CRYPT = "UA1_CRYPT\u0000";
    public static String CONST_CERTCRYPT = "CERTCRYPT\u0000";
    String signS = "UA1_SIGN\u0000";
    String sertS = "CERTCRYPT\u0000";
    String sign1S = "UA1_CRYPT\u0000";
    public static String crt;
    EndUser ee = null;
    String keyBB;
    String passBB;
    String keyDD;
    String passDD;
    String keyPP;
    String passPP;
    String ca = "acskidd.gov.ua";
    String lastErr = "";
    boolean cryptSetting;

    public Crypt(String crt, String ca, boolean crypt_setting) {
        Crypt.crt = crt;
        this.ca = ca;
        this.cryptSetting = crypt_setting;
    }

    public Crypt(String keyBB, String passBB, String keyDD, String passDD, String keyPP, String passPP, String crt, String ca) {
        this.keyBB = keyBB;
        this.passBB = passBB;
        this.keyPP = keyPP;
        this.passPP = passPP;
        this.keyDD = keyDD;
        this.passDD = passDD;
        Crypt.crt = crt;
        this.ca = ca;
    }

    public boolean init() {
        if (this.ee != null && this.ee.IsInitialized()) {
            return true;
        }
        this.ee = new EndUser();
        this.ee.SetUIMode(false);
        this.ee.SetCharset("UTF-8");
        try {
            EndUserProxySettings proxySettings;
            EndUserTSPSettings tspSettings;
            this.ee.Initialize();
            EndUserFileStoreSettings fileStoreSettings = this.ee.GetFileStoreSettings();
            if (fileStoreSettings == null || this.cryptSetting) {
                fileStoreSettings = this.ee.CreateFileStoreSettings();
                fileStoreSettings.SetExpireTime(3600);
                fileStoreSettings.SetSaveLoadedCerts(true);
                fileStoreSettings.SetAutoRefresh(true);
                fileStoreSettings.SetPath(crt);
            }
            this.ee.SetFileStoreSettings(fileStoreSettings);
            EndUserOCSPSettings ocspSettings = this.ee.GetOCSPSettings();
            if (ocspSettings == null || this.cryptSetting) {
                ocspSettings = this.ee.CreateOCSPSettings();
                ocspSettings.SetPort("80");
                ocspSettings.SetAddress(this.ca);
                ocspSettings.SetBeforeStore(true);
                ocspSettings.SetUseOCSP(true);
                this.ee.SetOCSPSettings(ocspSettings);
            }
            if ((tspSettings = this.ee.GetTSPSettings()) == null || this.cryptSetting) {
                tspSettings = this.ee.CreateTSPSettings();
                tspSettings.SetPort("80");
                tspSettings.SetAddress(this.ca);
                tspSettings.SetGetStamps(true);
            }
            this.ee.SetTSPSettings(tspSettings);
            EndUserCMPSettings cmpSettings = this.ee.GetCMPSettings();
            if (cmpSettings == null || this.cryptSetting) {
                cmpSettings = this.ee.CreateCMPSettings();
                cmpSettings.SetCommonName(this.ca);
                cmpSettings.SetPort("80");
                cmpSettings.SetAddress(this.ca);
                cmpSettings.SetUseCMP(true);
            }
            this.ee.SetCMPSettings(cmpSettings);
            EndUserLDAPSettings ldapSettings = this.ee.GetLDAPSettings();
            if (ldapSettings == null || this.cryptSetting) {
                ldapSettings = this.ee.CreateLDAPSettings();
                ldapSettings.SetPassword("password");
                ldapSettings.SetUser("user");
                ldapSettings.SetPort("389");
                ldapSettings.SetAddress(this.ca);
                ldapSettings.SetAnonymous(true);
                ldapSettings.SetUseLDAP(true);
                this.ee.SetLDAPSettings(ldapSettings);
            }
            if ((proxySettings = this.ee.GetProxySettings()) == null || this.cryptSetting) {
                proxySettings = this.ee.CreateProxySettings();
                proxySettings.SetUseProxy(false);
                this.ee.SetProxySettings(proxySettings);
            }
            EndUserModeSettings modeSettings = this.ee.CreateModeSettings();
            modeSettings.SetOfflineMode(false);
            this.ee.SetModeSettings(modeSettings);
            return true;
        }
        catch (Exception e) {
            this.lastErr = e.getMessage();
            return false;
        }
    }

    public byte[] sign(byte[] data, String key, String pass) throws Exception {
        this.readKeyFile(0, key, pass);
        String signdata = this.ee.SignInternal(true, data);
        byte[] sign = this.ee.BASE64Decode(signdata);
        int len = sign.length;
        byte[] blen = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(len).array();
        byte[] signSb = this.signS.getBytes();
        byte[] buf = new byte[sign.length + 4 + signSb.length];
        System.arraycopy(signSb, 0, buf, 0, signSb.length);
        System.arraycopy(blen, 0, buf, signSb.length, 4);
        System.arraycopy(sign, 0, buf, signSb.length + 4, sign.length);
        return buf;
    }

    public byte[] sign(byte[] data, byte[] key, String pass) {
        try {
            this.ee.ReadPrivateKeyBinary(key, pass);
            String signdata = this.ee.SignInternal(true, data);
            byte[] sign = this.ee.BASE64Decode(signdata);
            int len = sign.length;
            byte[] blen = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(len).array();
            byte[] signSb = this.signS.getBytes();
            byte[] buf = new byte[sign.length + 4 + signSb.length];
            System.arraycopy(signSb, 0, buf, 0, signSb.length);
            System.arraycopy(blen, 0, buf, signSb.length, 4);
            System.arraycopy(sign, 0, buf, signSb.length + 4, sign.length);
            return buf;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastErr = e.getMessage();
            return null;
        }
    }

    public byte[] signLast(byte[] data) throws Exception {
        String signdata = this.ee.SignInternal(true, data);
        byte[] sign = this.ee.BASE64Decode(signdata);
        int len = sign.length;
        byte[] blen = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(len).array();
        byte[] signSb = this.signS.getBytes();
        byte[] buf = new byte[sign.length + 4 + signSb.length];
        System.arraycopy(signSb, 0, buf, 0, signSb.length);
        System.arraycopy(blen, 0, buf, signSb.length, 4);
        System.arraycopy(sign, 0, buf, signSb.length + 4, sign.length);
        return buf;
    }

    byte[] criptDpUaKey(byte[] signData, String issuerTo, String serialTo, String pks2, String pps2) throws Exception {
        this.ee.ReadPrivateKeyFile(pks2, pps2);
        return this.criptDp(signData, issuerTo, serialTo);
    }

    private void readKeyFile(int cnt, String pks2, String pps2) throws Exception {
        block5: {
            try {
                this.ee.ReadPrivateKeyFile(pks2, pps2);
            }
            catch (EndUserException e) {
                if (e.GetErrorCode() != 51) break block5;
                if (cnt > 0) {
                    throw new RuntimeException("not read Certificates");
                }
                try {
                    EndUserPrivateKeyInfo endUserPrivateKeyInfo = this.ee.GetKeyInfoFile(pks2, pps2);
                    ArrayList<String> arrayList = new ArrayList<String>(Collections.singletonList(this.ca));
                    ArrayList<String> arrayListPort = new ArrayList<String>(Collections.singletonList("80"));
                    byte[] bytes = this.ee.GetCertificatesByKeyInfo(endUserPrivateKeyInfo, arrayList, arrayListPort);
                    this.ee.SaveCertificates(bytes);
                    this.readKeyFile(1, pks2, pps2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public byte[] criptDp(byte[] indata, String issuerTo, String serialTo) throws Exception {
        byte[] encryptionCert = this.findCrtToEnvelop();
        ArrayList<byte[]> srt = new ArrayList<byte[]>();
        byte[] crtTo = this.ee.GetCertificate(issuerTo, serialTo);
        srt.add(crtTo);
        String criptdata = this.ee.EnvelopToRecipientsWithDynamicKey(srt, false, false, indata);
        byte[] data = this.ee.BASE64Decode(criptdata);
        if (encryptionCert == null) {
            System.out.println("\u0412\u0456\u0434\u0441\u0443\u0442\u043d\u0456\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0456\u043a\u0430\u0442 \u0432\u0456\u0434\u043f\u0440\u0430\u0432\u043d\u0438\u043a\u0430");
            throw new Exception("\u0412\u0456\u0434\u0441\u0443\u0442\u043d\u0456\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0456\u043a\u0430\u0442 \u0432\u0456\u0434\u043f\u0440\u0430\u0432\u043d\u0438\u043a\u0430");
        }
        byte[] certLength = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(encryptionCert.length).array();
        byte[] certSb = this.sertS.getBytes();
        byte[] buf = new byte[encryptionCert.length + 4 + certSb.length];
        System.arraycopy(certSb, 0, buf, 0, certSb.length);
        System.arraycopy(certLength, 0, buf, certSb.length, 4);
        System.arraycopy(encryptionCert, 0, buf, certSb.length + 4, encryptionCert.length);
        byte[] sign1Sb = this.sign1S.getBytes();
        byte[] datLength = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(data.length).array();
        byte[] buf2 = new byte[buf.length + data.length + sign1Sb.length + 4];
        System.arraycopy(buf, 0, buf2, 0, buf.length);
        System.arraycopy(sign1Sb, 0, buf2, buf.length, sign1Sb.length);
        System.arraycopy(datLength, 0, buf2, buf.length + sign1Sb.length, 4);
        System.arraycopy(data, 0, buf2, buf.length + sign1Sb.length + 4, data.length);
        return buf2;
    }

    public byte[] mail(byte[] data, String fname, String email, String tin) {
        try {
            String tt = "TRANSPORTABLE\u0000";
            byte[] ttb = tt.getBytes();
            String heder = "CERTYPE=UA1\r\nRCV_NAME=\r\nEDRPOU=" + tin + "\r\nFILENAME=" + fname + "\r\nRCV_EMAIL=" + email + "\r\nPRG_TYPE=TaxReportAndr\r\nPRG_VER=1.0\r\nSND_DATE=20140911162828\r\n\u0000";
            byte[] hederb = heder.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(hederb.length);
            byte[] ttbLength = byteBuffer.array();
            byte[] buf = new byte[data.length + ttb.length + hederb.length + 4];
            System.arraycopy(ttb, 0, buf, 0, ttb.length);
            System.arraycopy(ttbLength, 0, buf, ttb.length, 4);
            System.arraycopy(hederb, 0, buf, ttb.length + 4, hederb.length);
            System.arraycopy(data, 0, buf, ttb.length + 4 + hederb.length, data.length);
            return buf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] findCrtToEnvelop() throws Exception {
        Integer i = 0;
        while (true) {
            EndUserCertificateInfoEx info;
            block4: {
                info = null;
                try {
                    info = this.ee.EnumOwnCertificates(i);
                }
                catch (EndUserException e) {
                    if (e.GetErrorCode() != 51) break block4;
                    System.out.println("51 ");
                }
            }
            if (info == null) break;
            if (info.GetKeyUsageType() == 16) {
                return this.ee.GetCertificate(info.GetIssuer(), info.GetSerial());
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return null;
    }

    private String findCrt(String id) {
        try {
            int count = this.ee.GetEndUserCertificatesCount();
            for (int i = 0; i < count; ++i) {
                EndUserOwnerInfo en = this.ee.EnumEndUserCertificatesCount(i);
                if (!en.GetSerial().equals(id)) continue;
                return en.GetIssuer();
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public byte[] developUaKey(byte[] data, String pks2, String pps2) throws Exception {
        this.ee.ReadPrivateKeyFile(pks2, pps2);
        return this.develop(data);
    }

    public byte[] develop(byte[] data) throws Exception {
        if (Crypt.chkTypeBloc(data).equals(CONST_SIGN)) {
            data = this.getBytesAfterBloc(data, CONST_SIGN);
        }
        if (Crypt.chkTypeBloc(data).equals(CONST_CRYPT)) {
            data = Crypt.getBytesFromBloc(data, CONST_CRYPT);
            EndUserSenderInfo e = this.ee.Develop(DatatypeConverter.printBase64Binary((byte[])data));
            return e.GetData();
        }
        return data;
    }

    public byte[] extractData(byte[] data) throws Exception {
        while (Crypt.chkTypeBloc(data).equals(CONST_SIGN)) {
            data = Crypt.getBytesFromBloc(data, CONST_SIGN);
            EndUserSignInfo sd = this.ee.VerifyInternal(DatatypeConverter.printBase64Binary((byte[])data));
            System.out.println(String.format("SignInfo %s , %s", sd.GetOwnerInfo().GetSerial(), sd.GetOwnerInfo().GetSubjCN()));
            data = sd.GetData();
        }
        return data;
    }

    public byte[] getBytesAfterBloc(byte[] data, String constCrypt) {
        Integer ln_header = constCrypt.getBytes().length;
        Integer bloc_ln = ByteBuffer.wrap(Crypt.getByteLn(data, ln_header, 4)).order(ByteOrder.LITTLE_ENDIAN).getInt();
        Integer dataLn = data.length - (ln_header + 4 + bloc_ln);
        return Crypt.getByteLn(data, ln_header + 4 + bloc_ln, dataLn);
    }

    public static String chkTypeBloc(byte[] data) {
        byte[] c = CONST_CRYPT.getBytes();
        byte[] header = Crypt.getByteLn(data, 0, c.length);
        if (Arrays.equals(header, c)) {
            return CONST_CRYPT;
        }
        c = CONST_TR.getBytes();
        header = Crypt.getByteLn(data, 0, c.length);
        if (Arrays.equals(header, c)) {
            return CONST_TR;
        }
        c = CONST_SIGN.getBytes();
        header = Crypt.getByteLn(data, 0, c.length);
        if (Arrays.equals(header, c)) {
            return CONST_SIGN;
        }
        c = CONST_CERTCRYPT.getBytes();
        header = Crypt.getByteLn(data, 0, c.length);
        if (Arrays.equals(header, c)) {
            return CONST_CERTCRYPT;
        }
        return "";
    }

    public static byte[] getBytesFromBloc(byte[] data, String header) {
        Integer ln_header = header.getBytes().length;
        Integer bloc_ln = ByteBuffer.wrap(Crypt.getByteLn(data, ln_header, 4)).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return Crypt.getByteLn(data, ln_header + 4, bloc_ln);
    }

    public static byte[] getByteLn(byte[] data, int start, int ln) {
        byte[] ltr = new byte[ln];
        for (int i = 0; i < ln; ++i) {
            ltr[i] = data[i + start];
        }
        return ltr;
    }

    public boolean mailaddtarnsport(String fname, String tin, String email, InputStream dt) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            String date = formatter.format(new Date());
            byte[] data = Utils.read(dt);
            byte[] ttb = CONST_TR.getBytes();
            String heder = "CERTYPE=UA1\r\nRCV_NAME=\r\nEDRPOU=" + tin + "\r\nFILENAME=" + fname + "\r\nRCV_EMAIL=" + email + "\r\nPRG_TYPE=TaxReport\r\nPRG_VER=1.0\r\nSND_DATE=" + date + "\r\n\u0000";
            byte[] hederb = heder.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(hederb.length);
            byte[] ttbLength = byteBuffer.array();
            byte[] buf = new byte[data.length + ttb.length + hederb.length + 4];
            System.arraycopy(ttb, 0, buf, 0, ttb.length);
            System.arraycopy(ttbLength, 0, buf, ttb.length, 4);
            System.arraycopy(hederb, 0, buf, ttb.length + 4, hederb.length);
            System.arraycopy(data, 0, buf, ttb.length + 4 + hederb.length, data.length);
            FileOutputStream fos4 = new FileOutputStream(fname);
            fos4.write(buf);
            fos4.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.lastErr = e.getMessage();
            return false;
        }
    }

    private static byte[] getdataFromblok(byte[] data, String heder) {
        Integer ln_heder = heder.getBytes().length;
        Integer bloc_ln = ByteBuffer.wrap(Crypt.getbuteln(data, ln_heder, 4)).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return Crypt.getbuteln(data, ln_heder + 4, bloc_ln);
    }

    private static byte[] getbuteln(byte[] data, int start, int ln) {
        byte[] ltr = new byte[ln];
        for (int i = 0; i < ln; ++i) {
            ltr[i] = data[i + start];
        }
        return ltr;
    }

    public String getLastErr() {
        return this.lastErr;
    }

    public String getPatchToCrt() throws Exception {
        return this.ee.GetFileStoreSettings().GetPath();
    }

    public void reloadCrt() throws Exception {
        this.ee.RefreshFileStore(true);
    }
}

