/*
 * Decompiled with CFR 0.152.
 */
package com.iit.certificateAuthority.endUser.libraries.signJava;

import com.iit.certificateAuthority.endUser.libraries.signJava.EndUser;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserLibraryUtils;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class EndUserResourceExtractor {
    private static boolean isWindows;
    private static boolean isSunOS;
    private static boolean isMacOS;
    private static boolean isFreeBSD;
    private static boolean isAIX;
    private static boolean isAndroid;
    private static boolean isARM;
    private static boolean isSPARC;
    private static boolean isX86;
    private static boolean isARM64;
    private static String path;
    private static boolean preLoad;
    private static boolean isExtractableResources;
    private static boolean loadFromPath;
    private static String version;
    private static final Map winResourcesNames;
    private static final Map nixResourcesNames;
    private static final Map macResourcesNames;
    private static final Map androidResourcesNames;
    public static URL codebaseURL;

    private static boolean GetIsAndroidSafe() {
        boolean bl = false;
        try {
            bl |= System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bl |= System.getProperty("java.runtime.name").toLowerCase().indexOf("android") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bl |= System.getProperty("java.specification.vendor").toLowerCase().indexOf("android") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static String GetJarLibraryPath() {
        try {
            CodeSource codeSource = EndUserResourceExtractor.class.getProtectionDomain().getCodeSource();
            File file = new File(codeSource.getLocation().toURI().getPath());
            String string = file.getParentFile().getPath();
            if (string.charAt(string.length() - 1) == '/') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String GetResourcesLocation() {
        String string = isWindows ? "/Libraries/Win" : (isMacOS ? "/Libraries/Mac" : (isAndroid ? (isExtractableResources ? "/libs" : "/lib") : "/Libraries/Nix"));
        if (isSunOS) {
            string = string + "/SunOS";
        } else if (isFreeBSD) {
            string = string + "/FreeBSD";
        } else if (isAIX) {
            string = string + "/AIX";
        }
        if (isAndroid) {
            string = isARM ? string + "/armeabi" : (isARM64 ? string + "/arm64-v8a" : (isX86 ? string + "/x86" : string + "/x86_64"));
        } else if (isARM) {
            string = string + "/arm";
        } else if (isSPARC) {
            string = string + "/sparc";
        } else if (!isX86) {
            string = string + "/64";
        }
        return string;
    }

    private static String GetLibrariesZipFileName() {
        if (isAndroid) {
            return "";
        }
        String string = "EUSignJavaLibs";
        string = isWindows ? string + ".Win" : (isMacOS ? string + ".Mac" : string + ".Nix");
        if (isSunOS) {
            string = string + ".SunOS";
        } else if (isFreeBSD) {
            string = string + ".FreeBSD";
        } else if (isAIX) {
            string = string + ".AIX";
        }
        if (isARM) {
            string = string + ".arm";
        } else if (isSPARC) {
            string = string + ".sparc";
        } else if (!isX86) {
            string = string + ".64";
        }
        return string + ".zip";
    }

    private static Map GetResources() {
        if (isWindows) {
            return winResourcesNames;
        }
        if (isMacOS) {
            return macResourcesNames;
        }
        if (isAndroid) {
            return androidResourcesNames;
        }
        return nixResourcesNames;
    }

    private static String[] GetResourcesNames() {
        Map map = EndUserResourceExtractor.GetResources();
        String[] stringArray = (String[])map.get("required");
        String[] stringArray2 = (String[])map.get("optional");
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private static boolean IsResourceExistsInJar(String string) {
        InputStream inputStream = EndUserResourceExtractor.class.getResourceAsStream(string);
        return inputStream != null;
    }

    private static boolean IsResourceExistsInFileSystem(String string) {
        File file = new File(string);
        return file.exists();
    }

    private static boolean CheckFileHash(String string, String string2) {
        byte[] byArray = new byte[1024];
        try {
            int n;
            InputStream inputStream = new FileInputStream(new File(string + "/" + string2));
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            while ((n = inputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            inputStream.close();
            inputStream = EndUserResourceExtractor.class.getResourceAsStream("/Hashes/" + string2 + ".hash");
            byte[] byArray3 = new byte[byArray2.length];
            int n2 = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                if (n2 + n > byArray3.length) {
                    inputStream.close();
                    return false;
                }
                System.arraycopy(byArray, 0, byArray3, n2, n);
                n2 += n;
            }
            inputStream.close();
            return Arrays.equals(byArray2, byArray3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean CheckRequiredResources(String string) {
        Map map = EndUserResourceExtractor.GetResources();
        String[] stringArray = (String[])map.get("required");
        for (int i = 0; i < stringArray.length; ++i) {
            if (EndUserResourceExtractor.IsResourceExistsInFileSystem(string + '/' + stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private static void WriteResourceToFile(String string, String string2) throws Exception {
        byte[] byArray = new byte[1024];
        int n = -1;
        InputStream inputStream = EndUserResourceExtractor.class.getResourceAsStream(string);
        if (inputStream == null) {
            return;
        }
        File file = new File(string2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = inputStream.read(byArray)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
    }

    private static void WriteResourceToFile(URL uRL, String string) throws Exception {
        byte[] byArray = new byte[1024];
        int n = -1;
        InputStream inputStream = uRL.openStream();
        File file = new File(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = inputStream.read(byArray)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        inputStream.close();
    }

    private static void WriteResourcesToPath(URL uRL, String string) throws Exception {
        String string2 = string + "/" + EndUserResourceExtractor.GetLibrariesZipFileName();
        EndUserResourceExtractor.WriteResourceToFile(uRL, string2);
        byte[] byArray = new byte[1024];
        if (!EndUserResourceExtractor.CheckFileHash(string, EndUserResourceExtractor.GetLibrariesZipFileName())) {
            throw new IOException();
        }
        FileInputStream fileInputStream = new FileInputStream(new File(string2));
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            int n;
            String string3 = zipEntry.getName();
            File file = new File(string + '/' + string3);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n = zipInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.close();
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
    }

    public static void UnzipFile(String string) throws Exception {
        byte[] byArray = new byte[1024];
        File file = new File(string);
        ZipFile zipFile = new ZipFile(file);
        String string2 = string.substring(0, string.length() - 4);
        new File(string2).mkdir();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = enumeration.nextElement();
            File file2 = new File(string2, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                file2.mkdir();
                continue;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), byArray.length);
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
    }

    private static void PreLoadResource(String string) throws Exception {
        if (loadFromPath ? !EndUserResourceExtractor.IsResourceExistsInFileSystem(string) : !EndUserResourceExtractor.IsResourceExistsInJar(string)) {
            return;
        }
        if (string.indexOf(".dll") < 0 && string.indexOf(".so") < 0 && string.indexOf(".dylib") < 0) {
            return;
        }
        if (loadFromPath) {
            System.load(string);
        } else {
            String string2 = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf("."));
            if (string2.startsWith("lib")) {
                string2 = string2.substring(3);
            }
            System.loadLibrary(string2);
        }
        if (!isWindows && (isMacOS && string.indexOf("libEUSignJavaUtils.dylib") >= 0 || string.indexOf("libEUSignJavaUtils.so") >= 0)) {
            try {
                new EndUserLibraryUtils().SetCurrentDirectory(EndUserResourceExtractor.GetInstallPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void RemoveDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                EndUserResourceExtractor.RemoveDirectory(fileArray[i]);
            }
        }
        if (!file.delete()) {
            throw new FileNotFoundException();
        }
    }

    public static boolean IsWindows() {
        return isWindows;
    }

    public static void SetPath(String string) {
        path = string;
    }

    public static String GetPath() {
        return path;
    }

    public static void SetPreLoad(boolean bl) {
        preLoad = bl;
    }

    public static boolean GetPreLoad() {
        return preLoad;
    }

    public static String GetInstallPath() {
        String string = path.equals("") ? System.getProperty("java.io.tmpdir") : path;
        if (!isExtractableResources) {
            return string;
        }
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        string = string + "EUSign";
        string = isARM ? string + "-arm-" : (isSPARC ? string + "-sparc-" : (isX86 ? string + "-x86-" : string + "-x64-"));
        string = string + version;
        return string;
    }

    public static String ExtractResources() throws Exception {
        String string = EndUserResourceExtractor.GetInstallPath();
        String string2 = EndUserResourceExtractor.GetResourcesLocation();
        String[] stringArray = EndUserResourceExtractor.GetResourcesNames();
        File file = new File(string);
        if (!(!isExtractableResources || file.exists() && EndUserResourceExtractor.CheckRequiredResources(string))) {
            file.mkdir();
            try {
                int n;
                if (EndUserResourceExtractor.IsResourceExistsInJar(string2 + "/" + stringArray[0])) {
                    for (n = 0; n < stringArray.length; ++n) {
                        EndUserResourceExtractor.WriteResourceToFile(string2 + "/" + stringArray[n], string + "/" + stringArray[n]);
                    }
                } else {
                    EndUserResourceExtractor.WriteResourcesToPath(new URL(codebaseURL, EndUserResourceExtractor.GetLibrariesZipFileName()), string);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    String string3 = string + "/" + stringArray[n];
                    if (!string3.endsWith(".zip") || !EndUserResourceExtractor.IsResourceExistsInFileSystem(string3)) continue;
                    EndUserResourceExtractor.UnzipFile(string3);
                }
            }
            catch (Exception exception) {
                EndUserResourceExtractor.RemoveDirectory(file);
                throw exception;
            }
        }
        if (preLoad) {
            String string4 = loadFromPath ? string : string2;
            for (int i = 0; i < stringArray.length; ++i) {
                EndUserResourceExtractor.PreLoadResource(string4 + "/" + stringArray[i]);
            }
        }
        return string;
    }

    public static boolean SetUSBDevice(int n, byte[] byArray) {
        if (!isWindows) {
            try {
                return new EndUserLibraryUtils().SetUSBDevice(n, byArray);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static InputStream GetSettingsFile(String string) {
        try {
            return EndUserResourceExtractor.class.getResourceAsStream("/Settings/" + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String MapLibraryName(String string) {
        if (isMacOS) {
            return "lib" + string + ".dylib";
        }
        if (isAIX) {
            return "lib" + string + ".so";
        }
        if (isAndroid) {
            return "lib" + string + ".so";
        }
        return System.mapLibraryName(string);
    }

    public static void LoadLibrary(String string) {
        if (loadFromPath) {
            String string2 = EndUserResourceExtractor.GetInstallPath() + "/" + EndUserResourceExtractor.MapLibraryName(string);
            System.load(string2);
        } else {
            System.loadLibrary(string);
        }
    }

    static {
        path = "";
        preLoad = false;
        isExtractableResources = true;
        loadFromPath = true;
        version = "1.3.100";
        winResourcesNames = Collections.unmodifiableMap(new HashMap(){
            {
                this.put("required", new String[]{"EUSignJava.dll", "EUSignCP.dll", "CSPBase.dll", "CSPIBase.dll", "CSPExtension.dll", "PKIFormats.dll", "KM.dll", "CAConnectors.dll", "LDAPClient.dll", "RF.dll"});
                this.put("optional", new String[]{"CAGUI.dll", "KM.EKeyAlmaz1C.dll", "KM.EKeyCrystal1.dll", "KM.FileSystem.dll", "KM.TCTEllipseSCard.dll", "KM.PKCS11.dll", "PKCS11.EKeyAlmaz1C.dll", "PKCS11.EKeyCrystal1.dll", "DSTU4145Parameters.cap", "ECDHParameters.cap", "GOST28147SBox.cap", "PRNGParameters.cap", "RSAParameters.cap"});
            }
        });
        nixResourcesNames = Collections.unmodifiableMap(new HashMap(){
            {
                this.put("required", new String[]{"libEUSignJavaUtils.so", "libosi.so", "libEUSignJava.so", "euscp.so", "cspb.so", "cspib.so", "cspe.so", "pkif.so", "km.so", "cac.so", "ldapc.so"});
                this.put("optional", new String[]{"cagui.so", "libusb.so", "km.ekc1.so", "ekc1.so", "km.fs.so", "km.ncmg301.so", "ncmg301.so", "km.pkcs11.so", "pkcs11.ekc1.so", "pkcs11.eka1c.so", "osplm.ini", "DSTU4145Parameters.cap", "ECDHParameters.cap", "GOST28147SBox.cap", "PRNGParameters.cap", "RSAParameters.cap"});
            }
        });
        macResourcesNames = Collections.unmodifiableMap(new HashMap(){
            {
                this.put("required", new String[]{"libEUSignJavaUtils.dylib", "osi.dylib", "libEUSignJava.dylib", "euscp.dylib", "cspb.dylib", "cspib.dylib", "cspe.dylib", "pkif.dylib", "km.dylib", "cac.dylib", "ldapc.dylib"});
                this.put("optional", new String[]{"cagui.dylib", "cagui.bundle.zip", "libusb.dylib", "km.ekc1.dylib", "ekc1.dylib", "km.fs.dylib", "km.pkcs11.dylib", "pkcs11.ekc1.dylib", "pkcs11.eka1c.dylib", "osplm.ini", "DSTU4145Parameters.cap", "ECDHParameters.cap", "GOST28147SBox.cap", "PRNGParameters.cap", "RSAParameters.cap"});
            }
        });
        androidResourcesNames = Collections.unmodifiableMap(new HashMap(){
            {
                this.put("required", new String[]{"libEUSignJavaUtils.so", "libosi.so", "libEUSignJava.so", "libeuscp.so", "libcspb.so", "libcspib.so", "libcspe.so", "libpkif.so", "libkm.so", "libcac.so", "libldapc.so"});
                this.put("optional", new String[]{"libcagui.so", "libusb.so", "libkm.ekc1.so", "libekc1.so", "libkm.fs.so", "libkm.pkcs11.so", "libpkcs11.ekc1.so", "libpkcs11.eka1c.so", "osplm.ini", "DSTU4145Parameters.cap", "ECDHParameters.cap", "GOST28147SBox.cap", "PRNGParameters.cap", "RSAParameters.cap"});
            }
        });
        codebaseURL = null;
        try {
            String string = System.getProperty("os.name").toLowerCase();
            String string2 = System.getProperty("os.arch").toLowerCase();
            isWindows = string.indexOf("win") >= 0;
            isSunOS = string.indexOf("sunos") >= 0;
            isMacOS = string.indexOf("mac") >= 0;
            isFreeBSD = string.indexOf("freebsd") >= 0;
            isAIX = string.indexOf("aix") >= 0;
            isAndroid = EndUserResourceExtractor.GetIsAndroidSafe();
            isARM64 = string2.indexOf("aarch64") >= 0;
            isARM = !isARM64 && string2.indexOf("arm") >= 0;
            isSPARC = string2.indexOf("sparc") >= 0;
            boolean bl = isX86 = "x86".compareTo(string2) == 0 || "i386".compareTo(string2) == 0 || "i686".compareTo(string2) == 0;
            if (isAndroid || !Applet.class.isAssignableFrom(EndUser.class)) {
                String string3;
                String string4 = EndUserResourceExtractor.GetResourcesLocation();
                Map map = EndUserResourceExtractor.GetResources();
                String string5 = ((String[])map.get("required"))[0];
                isExtractableResources = EndUserResourceExtractor.IsResourceExistsInJar(string4 + "/" + string5);
                if (!isExtractableResources) {
                    loadFromPath = false;
                }
                if (!isExtractableResources && !isAndroid && (string3 = EndUserResourceExtractor.GetJarLibraryPath()) != null && EndUserResourceExtractor.IsResourceExistsInFileSystem(string3 + "/" + string5)) {
                    path = string3;
                    loadFromPath = true;
                }
            }
        }
        catch (Exception exception) {
            isWindows = true;
            isSPARC = false;
            isAIX = false;
            isARM = false;
            isARM64 = false;
            isX86 = true;
            isAndroid = false;
        }
    }
}

