/*
 * Decompiled with CFR 0.152.
 */
package com.iit.certificateAuthority.endUser.libraries.signJava;

import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserResourceExtractor;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndUserKeyMediaAccessChecker {
    private static boolean isInitialized = false;
    private static boolean isSettingsFileExist = false;
    private static boolean isNoRestrictions = false;
    private static Element settingsRootElement = null;

    public static void Initialize() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        InputStream inputStream = EndUserResourceExtractor.GetSettingsFile("PermittedKeyMedias.xml");
        if (inputStream == null) {
            return;
        }
        isSettingsFileExist = true;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            settingsRootElement = document.getDocumentElement();
            if (settingsRootElement == null) {
                return;
            }
            isNoRestrictions = EndUserKeyMediaAccessChecker.GetNodeWithAttribute(settingsRootElement, "type", "name", "\u0432\u0441\u0456") != null;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static Node GetNodeWithAttribute(Element element, String string, String string2, String string3) {
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node node2 = node.getAttributes().getNamedItem(string2);
            if (node2 == null || !string3.equals(node2.getNodeValue())) continue;
            return node;
        }
        return null;
    }

    private static int GetChildCount(Element element, String string) {
        return element.getElementsByTagName(string).getLength();
    }

    private static Node GetNodeWithValue(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!string2.equals(node.getFirstChild().getNodeValue())) continue;
            return node;
        }
        return null;
    }

    public static boolean IsKeyMediaPermitted(String string, String string2) {
        EndUserKeyMediaAccessChecker.Initialize();
        if (!isSettingsFileExist || settingsRootElement == null) {
            return false;
        }
        if (isNoRestrictions) {
            return true;
        }
        try {
            Node node = EndUserKeyMediaAccessChecker.GetNodeWithAttribute(settingsRootElement, "type", "name", string);
            if (node == null) {
                return false;
            }
            if (EndUserKeyMediaAccessChecker.GetChildCount((Element)node, "device") == 0) {
                return true;
            }
            Node node2 = EndUserKeyMediaAccessChecker.GetNodeWithValue((Element)node, "device", string2);
            return node2 != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean IsBinaryKeyPermitted() {
        return EndUserKeyMediaAccessChecker.IsKeyMediaPermitted("\u0434\u0432\u0456\u0439\u043a\u043e\u0432\u0456 \u0434\u0430\u043d\u0456", null);
    }

    public static boolean IsSelectKeyMediaPermitted() {
        EndUserKeyMediaAccessChecker.Initialize();
        if (!isSettingsFileExist || settingsRootElement == null) {
            return false;
        }
        return isNoRestrictions;
    }
}

