/*
 * Decompiled with CFR 0.152.
 */
package com.iit.certificateAuthority.endUser.libraries.signJava;

import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserBASE64Converter;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCMPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCRLDetailedInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCRLInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCertificateInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCertificateInfoEx;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserCryptoHeader;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserDeviceContext;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserError;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserException;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserFileStoreSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserJKSPrivateKey;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserKeyMedia;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserKeyMediaAccessChecker;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserKeyMediaSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserLDAPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserLibrary;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserModeSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOCSPAccessInfoModeSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOCSPAccessInfoSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOCSPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOperationContext;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserOwnerInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserPrivateKeyInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserProxySettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserReceiverCertificate;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserRequestInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSCClientStatistic;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSenderInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSession;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSignInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserSigner;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserTSPSettings;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserTimeInfo;
import com.iit.certificateAuthority.endUser.libraries.signJava.EndUserTransportHeader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class EndUser {
    protected EndUserLibrary library;
    private String charset = null;
    private String lastError = "";
    private int lastErrorCode;
    private int language = 0;
    public static final int SUBJECT_TYPE_UNDIFFERENCED = 0;
    public static final int SUBJECT_TYPE_CA = 1;
    public static final int SUBJECT_TYPE_CA_SERVER = 2;
    public static final int SUBJECT_TYPE_RA_ADMINISTRATOR = 3;
    public static final int SUBJECT_TYPE_END_USER = 4;
    public static final int SUBJECT_CA_SERVER_SUB_TYPE_UNDIFFERENCED = 0;
    public static final int SUBJECT_CA_SERVER_SUB_TYPE_CMP = 1;
    public static final int SUBJECT_CA_SERVER_SUB_TYPE_TSP = 2;
    public static final int SUBJECT_CA_SERVER_SUB_TYPE_OCSP = 3;
    public static final int CERT_KEY_TYPE_UNKNOWN = 0;
    public static final int CERT_KEY_TYPE_DSTU4145 = 1;
    public static final int CERT_KEY_TYPE_RSA = 2;
    public static final int KEY_USAGE_UNKNOWN = 0;
    public static final int KEY_USAGE_DIGITAL_SIGNATUR = 1;
    public static final int KEY_KEY_USAGE_KEY_AGREEMENT = 16;
    public static final int EU_KEYS_REQUEST_TYPE_UA_DS = 1;
    public static final int EU_KEYS_REQUEST_TYPE_UA_KEP = 2;
    public static final int EU_KEYS_REQUEST_TYPE_INTERNATIONAL = 3;
    public static final int EU_KEYS_TYPE_NONE = 0;
    public static final int EU_KEYS_TYPE_DSTU_AND_ECDH_WITH_GOSTS = 1;
    public static final int EU_KEYS_TYPE_RSA_WITH_SHA = 2;
    public static final int EU_KEYS_LENGTH_DS_UA_191 = 1;
    public static final int EU_KEYS_LENGTH_DS_UA_257 = 2;
    public static final int EU_KEYS_LENGTH_DS_UA_307 = 3;
    public static final int EU_KEYS_LENGTH_DS_UA_FILE = 4;
    public static final int EU_KEYS_LENGTH_KEP_UA_257 = 1;
    public static final int EU_KEYS_LENGTH_KEP_UA_431 = 2;
    public static final int EU_KEYS_LENGTH_KEP_UA_571 = 3;
    public static final int EU_KEYS_LENGTH_KEP_UA_FILE = 4;
    public static final int EU_KEYS_LENGTH_DS_RSA_1024 = 1;
    public static final int EU_KEYS_LENGTH_DS_RSA_2048 = 2;
    public static final int EU_KEYS_LENGTH_DS_RSA_3072 = 3;
    public static final int EU_KEYS_LENGTH_DS_RSA_4096 = 4;
    public static final int EU_KEYS_LENGTH_DS_RSA_FILE = 5;
    public static final int EU_RECIPIENT_APPEND_ISSUER_AND_SERIAL = 1;
    public static final int EU_RECIPIENT_APPEND_KEY_ID = 2;
    public static final int EU_RECIPIENT_APPEND_KEY_ID_USC_COMPAT = 3;
    public static final String EU_RESOLVE_OIDS_PARAMETER = "ResolveOIDs";
    public static final String EU_MAKE_PKEY_PFX_CONTAINER_PARAMETER = "MakePKeyPFXContainer";
    public static final String EU_SAVE_SETTINGS_PARAMETER = "SaveSettings";
    public static final String EU_SIGN_INCLUDE_CONTENT_TIME_STAMP_PARAMETER = "SignIncludeContentTimeStamp";
    public static final String EU_SIGN_TYPE_PARAMETER = "SignType";
    public static final String EU_SIGN_INCLUDE_CA_CERTIFICATES_PARAMETER = "SignIncludeCACertificates";
    public static final int EU_SETTINGS_ID_NONE = 0;
    public static final int EU_SETTINGS_ID_MANDATORY = 31;
    public static final int EU_SETTINGS_ID_ALL = 1023;
    public static final int EU_SETTINGS_ID_FSTORE = 1;
    public static final int EU_SETTINGS_ID_PROXY = 2;
    public static final int EU_SETTINGS_ID_TSP = 4;
    public static final int EU_SETTINGS_ID_OCSP = 8;
    public static final int EU_SETTINGS_ID_LDAP = 16;
    public static final int EU_SETTINGS_ID_MODE = 32;
    public static final int EU_SETTINGS_ID_CMP = 64;
    public static final int EU_SETTINGS_ID_KM = 128;
    public static final int EU_SETTINGS_ID_OCSP_ACCESS_INFO_MODE = 256;
    public static final int EU_SETTINGS_ID_OCSP_ACCESS_INFO = 512;
    public static final String EU_HEADER_CA_TYPE = "UA1";
    public static final int EU_HEADER_PART_TYPE_SIGNED = 1;
    public static final int EU_HEADER_PART_TYPE_ENCRYPTED = 2;
    public static final int EU_HEADER_PART_TYPE_STAMPED = 3;
    public static final int EU_HEADER_PART_TYPE_CERTCRYPT = 4;
    public static final int EU_HEADER_MAX_CA_TYPE_SIZE = 3;
    public static final int EU_SIGNED_CRYPTO_HEADER = 1;
    public static final int EU_ENCRYPTED_CRYPTO_HEADER = 2;
    public static final int EU_TIMESTAMPED_CRYPTO_HEADER = 3;
    public static final int EU_CERTCRYPT_CRYPTO_HEADER = 4;
    public static final int EU_DEFAULT_LANG = 0;
    public static final int EU_UA_LANG = 1;
    public static final int EU_RU_LANG = 2;
    public static final int EU_EN_LANG = 3;
    public static final int EU_CONTENT_ENC_ALGO_TDES_CBC = 4;
    public static final int EU_CONTENT_ENC_ALGO_AES_128_CBC = 5;
    public static final int EU_CONTENT_ENC_ALGO_AES_192_CBC = 6;
    public static final int EU_CONTENT_ENC_ALGO_AES_256_CBC = 7;
    public static final int EU_DEV_CTX_MIN_PUBLIC_DATA_ID = 16;
    public static final int EU_DEV_CTX_MAX_PRIVATE_DATA_ID = 175;
    public static final String EU_UA_OID_EXT_KEY_USAGE_STAMP = "1.2.804.2.1.1.1.3.9";
    public static final int EU_REG_KEY_ROOT_PATH_DEFAULT = 0;
    public static final int EU_REG_KEY_ROOT_PATH_HKLM = 1;
    public static final int EU_REG_KEY_ROOT_PATH_HKCU = 2;
    public static final int EU_REG_KEY_ROOT_PATH_CURRENT = 3;
    public static final int EU_SIGN_TYPE_UNKNOWN = 0;
    public static final int EU_SIGN_TYPE_CADES_BES = 1;
    public static final int EU_SIGN_TYPE_CADES_T = 4;
    public static final int EU_SIGN_TYPE_CADES_C = 8;
    public static final int EU_SIGN_TYPE_CADES_X_LONG = 16;

    private String GetInteractionLibraryLoadErrorLangDesc(int n) {
        switch (this.language) {
            case 3: {
                return "Error at loading interaction library";
            }
            case 2: {
                return "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f";
            }
        }
        return "\u0412\u0438\u043d\u0438\u043a\u043b\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u0456 \u0431\u0456\u0431\u043b\u0456\u043e\u0442\u0435\u043a\u0438 \u0432\u0437\u0430\u0454\u043c\u043e\u0434\u0456\u0457";
    }

    private String GetCryptoLibraryLoadErrorLangDesc(int n) {
        switch (this.language) {
            case 3: {
                return "Error at loading cryptographic library";
            }
            case 2: {
                return "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u043a\u0438";
            }
        }
        return "\u0412\u0438\u043d\u0438\u043a\u043b\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u0456 \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u0444\u0456\u0447\u043d\u043e\u0457 \u0431\u0456\u0431\u043b\u0456\u043e\u0442\u0435\u043a\u0438";
    }

    private void CheckLibraryLoad() throws Exception {
        if (this.library == null) {
            this.lastError = this.GetInteractionLibraryLoadErrorLangDesc(this.language);
            this.lastErrorCode = 3;
            throw new EndUserException(this.lastError, this.lastErrorCode);
        }
        if (!this.library.IsLibraryLoaded()) {
            this.lastError = this.GetInteractionLibraryLoadErrorLangDesc(this.language) + ": " + this.library.GetLibraryLoadErrorDescription();
            this.lastErrorCode = 3;
            throw new EndUserException(this.lastError, this.lastErrorCode);
        }
        this.lastErrorCode = 0;
        switch (this.language) {
            case 3: {
                this.lastError = "Executed successfully";
                break;
            }
            case 2: {
                this.lastError = "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e";
                break;
            }
            default: {
                this.lastError = "\u0412\u0438\u043a\u043e\u043d\u0430\u043d\u043e \u0443\u0441\u043f\u0456\u0448\u043d\u043e";
            }
        }
    }

    private void RaiseError(int n) throws Exception {
        this.lastErrorCode = n;
        if (n == 3) {
            this.lastError = this.GetCryptoLibraryLoadErrorLangDesc(this.language);
        } else if (!this.library.IsLibraryLoaded()) {
            this.lastError = this.GetCryptoLibraryLoadErrorLangDesc(this.language) + ": " + this.library.GetLibraryLoadErrorDescription();
        } else {
            String[] stringArray = new String[]{null};
            this.library.GetErrorLangDescription(n, this.language, stringArray);
            this.lastError = stringArray[0];
        }
        throw new EndUserException(this.lastError, this.lastErrorCode);
    }

    private byte[] GetBytesFromString(String string) throws Exception {
        if (this.charset != null) {
            return string.getBytes(this.charset);
        }
        return string.getBytes();
    }

    private String SetBytesToString(byte[] byArray) throws Exception {
        if (this.charset != null) {
            return new String(byArray, this.charset);
        }
        return new String(byArray);
    }

    private String[] ArrayListToStringArray(ArrayList arrayList) throws Exception {
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private byte[][] ArrayListToByteArray(ArrayList arrayList) throws Exception {
        byte[][] byArrayArray = new byte[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArrayArray[i] = (byte[])arrayList.get(i);
        }
        return byArrayArray;
    }

    private short[] DateTimeFromString(String string) throws Exception {
        try {
            String string2 = "dd/MM/yyyy HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = simpleDateFormat.parse(string);
            short[] sArray = new short[]{(short)date.getYear(), (short)date.getMonth(), (short)date.getDate(), (short)date.getHours(), (short)date.getMinutes(), (short)date.getSeconds()};
            return sArray;
        }
        catch (ParseException parseException) {
            this.RaiseError(2);
            return null;
        }
    }

    public void SetCharset(String string) {
        this.charset = string;
    }

    public void SetLanguage(int n) {
        this.language = n;
    }

    public void Initialize() throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.Initialize();
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public boolean IsInitialized() {
        if (this.library == null) {
            return false;
        }
        return this.library.IsInitialized();
    }

    public void Finalize() {
        if (this.library == null) {
            return;
        }
        this.library.Finalize();
    }

    public void SetSettings() {
        if (this.library == null) {
            return;
        }
        this.library.SetSettings();
    }

    public void ShowCertificates() {
        if (this.library == null) {
            return;
        }
        this.library.ShowCertificates();
    }

    public void ShowCRLs() {
        if (this.library == null) {
            return;
        }
        this.library.ShowCRLs();
    }

    public void ReadPrivateKey() throws Exception {
        int n;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n = this.library.ReadPrivateKey())) {
            this.RaiseError(n);
        }
    }

    public EndUserKeyMedia GetPrivateKeyMedia() throws Exception {
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
            this.RaiseError(18);
        }
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        String[] stringArray = new String[]{null};
        int n = this.library.GetPrivateKeyMedia(nArray, nArray2, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserKeyMedia(nArray[0], nArray2[0], stringArray[0]);
    }

    public void ReadPrivateKeySilently(int n, int n2, String string) throws Exception {
        int n3;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n3 = this.library.ReadPrivateKeySilently(n, n2, string))) {
            this.RaiseError(n3);
        }
    }

    public void ReadPrivateKeySilently(EndUserKeyMedia endUserKeyMedia) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ReadPrivateKeySilently(endUserKeyMedia.GetTypeIndex(), endUserKeyMedia.GetDevIndex(), endUserKeyMedia.GetPassword());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserOwnerInfo GetPrivateKeyOwnerInfo() throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        int n = this.library.GetPrivateKeyOwnerInfo(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]);
    }

    public boolean IsPrivateKeyReaded() {
        if (this.library == null) {
            return false;
        }
        return this.library.IsPrivateKeyReaded();
    }

    public void ResetPrivateKey() {
        if (this.library == null) {
            return;
        }
        this.library.ResetPrivateKey();
    }

    public void ShowOwnCertificate() {
        if (this.library == null) {
            return;
        }
        this.library.ShowOwnCertificate();
    }

    public void ShowSignInfo(EndUserSignInfo endUserSignInfo) {
        if (this.library == null) {
            return;
        }
        this.library.ShowSignInfo(endUserSignInfo.GetOwnerInfo().GetIssuer(), endUserSignInfo.GetOwnerInfo().GetIssuerCN(), endUserSignInfo.GetOwnerInfo().GetSerial(), endUserSignInfo.GetOwnerInfo().GetSubject(), endUserSignInfo.GetOwnerInfo().GetSubjCN(), endUserSignInfo.GetOwnerInfo().GetSubjOrg(), endUserSignInfo.GetOwnerInfo().GetSubjOrgUnit(), endUserSignInfo.GetOwnerInfo().GetSubjTitle(), endUserSignInfo.GetOwnerInfo().GetSubjState(), endUserSignInfo.GetOwnerInfo().GetSubjLocality(), endUserSignInfo.GetOwnerInfo().GetSubjFullName(), endUserSignInfo.GetOwnerInfo().GetSubjAddress(), endUserSignInfo.GetOwnerInfo().GetSubjPhone(), endUserSignInfo.GetOwnerInfo().GetSubjEMail(), endUserSignInfo.GetOwnerInfo().GetSubjDNS(), endUserSignInfo.GetOwnerInfo().GetSubjEDRPOUCode(), endUserSignInfo.GetOwnerInfo().GetSubjDRFOCode(), endUserSignInfo.GetTimeInfo().IsTimeAvail(), endUserSignInfo.GetTimeInfo().IsTimeStamp(), endUserSignInfo.GetTimeInfo().GetTimeArray());
    }

    public String Sign(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.Sign(byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String Sign(String string) throws Exception {
        return this.Sign(this.GetBytesFromString(string));
    }

    public String Verify(String string, byte[] byArray, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.Verify(string, byArray, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String Verify(String string, String string2, boolean bl) throws Exception {
        return this.Verify(string, this.GetBytesFromString(string2), bl);
    }

    public EndUserSignInfo Verify(String string, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.VerifyEx(string, byArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public EndUserSignInfo Verify(String string, String string2) throws Exception {
        return this.Verify(string, this.GetBytesFromString(string2));
    }

    public String SignInternal(boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.SignInternal(bl, byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String SignInternal(boolean bl, String string) throws Exception {
        return this.SignInternal(bl, this.GetBytesFromString(string));
    }

    public byte[] VerifyInternal(String string, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        int n = this.library.VerifyInternal(string, byArrayArray, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public String VerifyInternalString(String string, boolean bl) throws Exception {
        return new String(this.VerifyInternal(string, bl), this.charset);
    }

    public EndUserSignInfo VerifyInternal(String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.VerifyInternalEx(string, byArrayArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), byArrayArray[0]);
    }

    public void ContinueSign(byte[] byArray, int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        int n3 = this.library.ContinueSignWithOffset(byArray, n, n2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void ContinueSign(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ContinueSign(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void ContinueSign(String string) throws Exception {
        this.ContinueSign(this.GetBytesFromString(string));
    }

    public String EndSign() throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndSign(stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public void BeginVerify(String string) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.BeginVerify(string);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void ContinueVerify(byte[] byArray, int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        int n3 = this.library.ContinueVerifyWithOffset(byArray, n, n2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void ContinueVerify(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ContinueVerify(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void ContinueVerify(String string) throws Exception {
        this.ContinueVerify(this.GetBytesFromString(string));
    }

    public String EndVerify(boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndVerify(bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo EndVerify() throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.EndVerifyEx(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public void ResetOperation() {
        if (this.library == null) {
            return;
        }
        this.library.ResetOperation();
    }

    public void SignFile(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SignFile(string, string2, bl);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String VerifyFileWithExternalSign(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.VerifyFileWithExternalSign(string, string2, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyFileWithExternalSign(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.VerifyFileWithExternalSignEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public String VerifyFileWithInternalSign(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.VerifyFileWithInternalSign(string, string2, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyFileWithInternalSign(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.VerifyFileWithInternalSignEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public EndUserOwnerInfo SelectCertificateInfo() throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        int n = this.library.SelectCertificateInfo(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]);
    }

    public void SetUIMode(boolean bl) {
        if (this.library == null) {
            return;
        }
        this.library.SetUIMode(bl);
    }

    public String Hash(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.Hash(byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String Hash(String string) throws Exception {
        return this.Hash(this.GetBytesFromString(string));
    }

    public void ContinueHash(byte[] byArray, int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        int n3 = this.library.ContinueHashWithOffset(byArray, n, n2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void ContinueHash(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ContinueHash(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void ContinueHash(String string) throws Exception {
        this.ContinueHash(this.GetBytesFromString(string));
    }

    public String EndHash() throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndHash(stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String HashFile(String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.HashFile(string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String SignHash(String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.SignHash(string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String VerifyHash(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.VerifyHash(string, string2, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyHash(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.VerifyHashEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public String EnumKeyMediaTypes(int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnumKeyMediaTypes(n, stringArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return "";
            }
        }
        return stringArray[0];
    }

    public String EnumKeyMediaDevices(int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n3 = this.library.EnumKeyMediaDevices(n, n2, stringArray);
        if (EndUserError.isError(n3)) {
            if (n3 != 7) {
                this.RaiseError(n3);
            } else {
                return "";
            }
        }
        return stringArray[0];
    }

    public EndUserFileStoreSettings CreateFileStoreSettings() {
        return new EndUserFileStoreSettings("", false, false, false, false, false, false, 3600);
    }

    public EndUserFileStoreSettings GetFileStoreSettings() throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        boolean[] blArray5 = new boolean[]{false};
        boolean[] blArray6 = new boolean[]{false};
        int[] nArray = new int[]{0};
        int n = this.library.GetFileStoreSettings(stringArray, blArray, blArray2, blArray3, blArray4, blArray5, blArray6, nArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserFileStoreSettings(stringArray[0], blArray[0], blArray2[0], blArray3[0], blArray4[0], blArray5[0], blArray6[0], nArray[0]);
    }

    public void SetFileStoreSettings(EndUserFileStoreSettings endUserFileStoreSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetFileStoreSettings(endUserFileStoreSettings.GetPath(), endUserFileStoreSettings.GetCheckCRLs(), endUserFileStoreSettings.GetAutoRefresh(), endUserFileStoreSettings.GetOwnCRLsOnly(), endUserFileStoreSettings.GetFullAndDeltaCRLs(), endUserFileStoreSettings.GetAutoDownloadCRLs(), endUserFileStoreSettings.GetSaveLoadedCerts(), endUserFileStoreSettings.GetExpireTime());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserProxySettings CreateProxySettings() {
        return new EndUserProxySettings(false, false, "", "80", "", "", false);
    }

    public EndUserProxySettings GetProxySettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        int n = this.library.GetProxySettings(blArray, blArray2, stringArray, stringArray2, stringArray3, stringArray4, blArray3);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserProxySettings(blArray[0], blArray2[0], stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], blArray3[0]);
    }

    public void SetProxySettings(EndUserProxySettings endUserProxySettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetProxySettings(endUserProxySettings.GetUseProxy(), endUserProxySettings.GetAnonymous(), endUserProxySettings.GetAddress(), endUserProxySettings.GetPort(), endUserProxySettings.GetUser(), endUserProxySettings.GetPassword(), endUserProxySettings.GetSavePassword());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserOCSPSettings CreateOCSPSettings() {
        return new EndUserOCSPSettings(false, false, "", "80");
    }

    public EndUserOCSPSettings GetOCSPSettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        int n = this.library.GetOCSPSettings(blArray, blArray2, stringArray, stringArray2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserOCSPSettings(blArray[0], blArray2[0], stringArray[0], stringArray2[0]);
    }

    public void SetOCSPSettings(EndUserOCSPSettings endUserOCSPSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetOCSPSettings(endUserOCSPSettings.GetUseOCSP(), endUserOCSPSettings.GetBeforeStore(), endUserOCSPSettings.GetAddress(), endUserOCSPSettings.GetPort());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserTSPSettings CreateTSPSettings() {
        return new EndUserTSPSettings(false, "", "80");
    }

    public EndUserTSPSettings GetTSPSettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        int n = this.library.GetTSPSettings(blArray, stringArray, stringArray2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserTSPSettings(blArray[0], stringArray[0], stringArray2[0]);
    }

    public void SetTSPSettings(EndUserTSPSettings endUserTSPSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetTSPSettings(endUserTSPSettings.GetGetStamps(), endUserTSPSettings.GetAddress(), endUserTSPSettings.GetPort());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserLDAPSettings CreateLDAPSettings() {
        return new EndUserLDAPSettings(false, "", "389", false, "", "");
    }

    public EndUserLDAPSettings GetLDAPSettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        int n = this.library.GetLDAPSettings(blArray, stringArray, stringArray2, blArray2, stringArray3, stringArray4);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserLDAPSettings(blArray[0], stringArray[0], stringArray2[0], blArray2[0], stringArray3[0], stringArray4[0]);
    }

    public void SetLDAPSettings(EndUserLDAPSettings endUserLDAPSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetLDAPSettings(endUserLDAPSettings.GetUseLDAP(), endUserLDAPSettings.GetAddress(), endUserLDAPSettings.GetPort(), endUserLDAPSettings.GetAnonymous(), endUserLDAPSettings.GetUser(), endUserLDAPSettings.GetPassword());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserCMPSettings CreateCMPSettings() {
        return new EndUserCMPSettings(false, "", "80", "");
    }

    public EndUserCMPSettings GetCMPSettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        int n = this.library.GetCMPSettings(blArray, stringArray, stringArray2, stringArray3);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCMPSettings(blArray[0], stringArray[0], stringArray2[0], stringArray3[0]);
    }

    public void SetCMPSettings(EndUserCMPSettings endUserCMPSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetCMPSettings(endUserCMPSettings.GetUseCMP(), endUserCMPSettings.GetAddress(), endUserCMPSettings.GetPort(), endUserCMPSettings.GetCommonName());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public boolean DoesNeedSetSettings() throws Exception {
        this.CheckLibraryLoad();
        return this.library.DoesNeedSetSettings();
    }

    public int GetCertificatesCount(int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        int[] nArray = new int[]{0};
        int n3 = this.library.GetCertificatesCount(n, n2, nArray);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
        return nArray[0];
    }

    public int GetCertificatesCount() throws Exception {
        return this.GetCertificatesCount(0, 0);
    }

    public int GetCACertificatesCount() throws Exception {
        return this.GetCertificatesCount(1, 0);
    }

    public int GetCAServerCertificatesCount() throws Exception {
        return this.GetCertificatesCount(2, 0);
    }

    public int GetCMPServerCertificatesCount() throws Exception {
        return this.GetCertificatesCount(2, 1);
    }

    public int GetOCSPServerCertificatesCount() throws Exception {
        return this.GetCertificatesCount(2, 3);
    }

    public int GetTSPServerCertificatesCount() throws Exception {
        return this.GetCertificatesCount(2, 2);
    }

    public int GetRAAdministratorCertificatesCount() throws Exception {
        return this.GetCertificatesCount(3, 0);
    }

    public int GetEndUserCertificatesCount() throws Exception {
        return this.GetCertificatesCount(4, 0);
    }

    public EndUserOwnerInfo EnumCertificates(int n, int n2, int n3) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        int n4 = this.library.EnumCertificates(n, n2, n3, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17);
        if (EndUserError.isError(n4)) {
            if (n4 != 7) {
                this.RaiseError(n4);
            } else {
                return null;
            }
        }
        return new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]);
    }

    public EndUserOwnerInfo EnumCertificates(int n) throws Exception {
        return this.EnumCertificates(0, 0, n);
    }

    public EndUserOwnerInfo EnumCACertificates(int n) throws Exception {
        return this.EnumCertificates(1, 0, n);
    }

    public EndUserOwnerInfo EnumCAServerCertificates(int n) throws Exception {
        return this.EnumCertificates(2, 0, n);
    }

    public EndUserOwnerInfo EnumCMPServerCertificatesCount(int n) throws Exception {
        return this.EnumCertificates(2, 1, n);
    }

    public EndUserOwnerInfo EnumOCSPServerCertificatesCount(int n) throws Exception {
        return this.EnumCertificates(2, 3, n);
    }

    public EndUserOwnerInfo EnumTSPServerCertificatesCount(int n) throws Exception {
        return this.EnumCertificates(2, 2, n);
    }

    public EndUserOwnerInfo EnumRAAdministratorCertificatesCount(int n) throws Exception {
        return this.EnumCertificates(3, 0, n);
    }

    public EndUserOwnerInfo EnumEndUserCertificatesCount(int n) throws Exception {
        return this.EnumCertificates(4, 0, n);
    }

    public int GetCRLsCount() throws Exception {
        this.CheckLibraryLoad();
        int[] nArray = new int[]{0};
        int n = this.library.GetCRLsCount(nArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return nArray[0];
    }

    public EndUserCRLInfo EnumCRLs(int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        int[] nArray = new int[]{0};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        int n2 = this.library.EnumCRLs(n, stringArray, stringArray2, nArray, sArray, sArray2);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return new EndUserCRLInfo(stringArray[0], stringArray2[0], nArray[0], sArray, sArray2);
    }

    public EndUserCertificateInfo GetCertificateInfo(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        boolean[] blArray5 = new boolean[]{false};
        int n = this.library.GetCertificateInfo(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray21, stringArray22, blArray2, nArray2, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, blArray3, blArray4, blArray5);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCertificateInfo(string, stringArray[0], string2, stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray21[0], stringArray22[0], blArray2[0], nArray2[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], blArray3[0], blArray4[0], blArray5[0]);
    }

    public EndUserCRLDetailedInfo GetCRLDetailedInfo(String string, int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        int[] nArray = new int[]{0};
        int n2 = this.library.GetCRLDetailedInfo(string, n, stringArray, stringArray2, sArray, sArray2, nArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserCRLDetailedInfo(string, stringArray[0], stringArray2[0], n, sArray, sArray2, nArray[0]);
    }

    public EndUserKeyMediaSettings CreateKeyMediaSettings() {
        return new EndUserKeyMediaSettings(1, true, new EndUserKeyMedia(0, 0, ""));
    }

    public EndUserKeyMediaSettings GetKeyMediaSettings() throws Exception {
        this.CheckLibraryLoad();
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        String[] stringArray = new String[]{null};
        int n = this.library.GetPrivateKeyMediaSettings(nArray, blArray, nArray2, nArray3, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserKeyMediaSettings(nArray[0], blArray[0], new EndUserKeyMedia(nArray2[0], nArray3[0], stringArray[0]));
    }

    public void SetKeyMediaSettings(EndUserKeyMediaSettings endUserKeyMediaSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetPrivateKeyMediaSettings(endUserKeyMediaSettings.GetSourceType(), endUserKeyMediaSettings.GetShowErrors(), endUserKeyMediaSettings.GetKeyMedia().GetTypeIndex(), endUserKeyMediaSettings.GetKeyMedia().GetDevIndex(), endUserKeyMediaSettings.GetKeyMedia().GetPassword());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String RawSign(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.RawSign(byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String RawSign(String string) throws Exception {
        return this.RawSign(this.GetBytesFromString(string));
    }

    public String RawVerify(String string, byte[] byArray, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.RawVerify(string, byArray, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String RawVerify(String string, String string2, boolean bl) throws Exception {
        return this.RawVerify(string, this.GetBytesFromString(string2), bl);
    }

    public EndUserSignInfo RawVerify(String string, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.RawVerifyEx(string, byArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public EndUserSignInfo RawVerify(String string, String string2) throws Exception {
        return this.RawVerify(string, this.GetBytesFromString(string2));
    }

    public String RawSignHash(String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.RawSignHash(string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String RawVerifyHash(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.RawVerifyHash(string, string2, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo RawVerifyHash(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.RawVerifyHashEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public void RawSignFile(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.RawSignFile(string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String RawVerifyFile(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.RawVerifyFile(string, string2, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo RawVerifyFile(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.RawVerifyFileEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public String BASE64Encode(byte[] byArray) {
        if (this.library == null || !this.library.IsLibraryLoaded()) {
            return new String(EndUserBASE64Converter.Encode(byArray));
        }
        String[] stringArray = new String[]{null};
        int n = this.library.BASE64Encode(byArray, stringArray);
        if (EndUserError.isError(n)) {
            return "";
        }
        return stringArray[0];
    }

    public byte[] BASE64Decode(String string) {
        if (this.library == null || !this.library.IsLibraryLoaded()) {
            return EndUserBASE64Converter.Decode(string);
        }
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.BASE64Decode(string, byArrayArray);
        if (EndUserError.isError(n)) {
            return null;
        }
        return byArrayArray[0];
    }

    public void ShowSenderInfo(EndUserSenderInfo endUserSenderInfo) {
        if (this.library == null) {
            return;
        }
        this.library.ShowSenderInfo(endUserSenderInfo.GetOwnerInfo().GetIssuer(), endUserSenderInfo.GetOwnerInfo().GetIssuerCN(), endUserSenderInfo.GetOwnerInfo().GetSerial(), endUserSenderInfo.GetOwnerInfo().GetSubject(), endUserSenderInfo.GetOwnerInfo().GetSubjCN(), endUserSenderInfo.GetOwnerInfo().GetSubjOrg(), endUserSenderInfo.GetOwnerInfo().GetSubjOrgUnit(), endUserSenderInfo.GetOwnerInfo().GetSubjTitle(), endUserSenderInfo.GetOwnerInfo().GetSubjState(), endUserSenderInfo.GetOwnerInfo().GetSubjLocality(), endUserSenderInfo.GetOwnerInfo().GetSubjFullName(), endUserSenderInfo.GetOwnerInfo().GetSubjAddress(), endUserSenderInfo.GetOwnerInfo().GetSubjPhone(), endUserSenderInfo.GetOwnerInfo().GetSubjEMail(), endUserSenderInfo.GetOwnerInfo().GetSubjDNS(), endUserSenderInfo.GetOwnerInfo().GetSubjEDRPOUCode(), endUserSenderInfo.GetOwnerInfo().GetSubjDRFOCode(), endUserSenderInfo.GetTimeInfo().IsTimeAvail(), endUserSenderInfo.GetTimeInfo().IsTimeStamp(), endUserSenderInfo.GetTimeInfo().GetTimeArray());
    }

    public String Envelop(String string, String string2, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.Envelop(string, string2, bl, byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String Envelop(String string, String string2, boolean bl, String string3) throws Exception {
        return this.Envelop(string, string2, bl, this.GetBytesFromString(string3));
    }

    public byte[] Develop(String string, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        int n = this.library.Develop(string, byArrayArray, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public EndUserSenderInfo Develop(String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.DevelopEx(string, byArrayArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSenderInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), byArrayArray[0]);
    }

    public EndUserCertificateInfo ParseCertificate(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        String[] stringArray31 = new String[]{null};
        String[] stringArray32 = new String[]{null};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        boolean[] blArray5 = new boolean[]{false};
        int n = this.library.ParseCertificate(byArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, blArray2, nArray2, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, stringArray31, stringArray32, blArray3, blArray4, blArray5);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCertificateInfo(stringArray[0], stringArray3[0], stringArray2[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], blArray2[0], nArray2[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], stringArray31[0], stringArray32[0], blArray3[0], blArray4[0], blArray5[0]);
    }

    public boolean IsSigned(byte[] byArray) {
        if (this.library == null) {
            return false;
        }
        return this.library.IsSignedData(byArray);
    }

    public boolean IsEnveloped(byte[] byArray) {
        if (this.library == null) {
            return false;
        }
        return this.library.IsEnvelopedData(byArray);
    }

    public void EnvelopFile(String string, String string2, boolean bl, String string3, String string4) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.EnvelopFile(string, string2, bl, string3, string4);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void DevelopFile(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.DevelopFile(string, string2, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserSenderInfo DevelopFile(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.DevelopFileEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSenderInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public boolean IsSignedFile(String string) {
        if (this.library == null) {
            return false;
        }
        return this.library.IsSignedFile(string);
    }

    public boolean IsEnvelopedFile(String string) {
        if (this.library == null) {
            return false;
        }
        return this.library.IsEnvelopedFile(string);
    }

    public byte[] GetCertificate(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.GetCertificate(string, string2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public byte[] GetOwnCertificate() throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.GetOwnCertificate(byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public byte[] GetOwnCertificate(int n, int n2) throws Exception {
        EndUserCertificateInfoEx endUserCertificateInfoEx;
        this.CheckLibraryLoad();
        int n3 = 0;
        while ((endUserCertificateInfoEx = this.EnumOwnCertificates(n3)) != null) {
            if (endUserCertificateInfoEx.GetPublicKeyType() == n && (endUserCertificateInfoEx.GetKeyUsageType() & n2) == n2) {
                return this.GetCertificate(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetSerial());
            }
            ++n3;
        }
        this.RaiseError(51);
        return null;
    }

    public void ReadPrivateKeyBinary(byte[] byArray, String string) throws Exception {
        int n;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsBinaryKeyPermitted()) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n = this.library.ReadPrivateKeyBinary(byArray, string))) {
            this.RaiseError(n);
        }
    }

    public void ReadPrivateKeyFile(String string, String string2) throws Exception {
        int n;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsBinaryKeyPermitted()) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n = this.library.ReadPrivateKeyFile(string, string2))) {
            this.RaiseError(n);
        }
    }

    public void SessionClose(EndUserSession endUserSession) throws Exception {
        this.CheckLibraryLoad();
        this.library.SessionDestroy(endUserSession.GetHandle());
    }

    public EndUserSession ClientSessionCreateStep1(int n) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.ClientSessionCreateStep1(n, lArray, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSession(lArray[0], byArrayArray[0]);
    }

    public EndUserSession ServerSessionCreateStep1(int n, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.ServerSessionCreateStep1(n, byArray, lArray, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSession(lArray[0], byArrayArray[0]);
    }

    public void ClientSessionCreateStep2(EndUserSession endUserSession, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.ClientSessionCreateStep2(endUserSession.GetHandle(), byArray, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        endUserSession.SetData(byArrayArray[0]);
    }

    public void ServerSessionCreateStep2(EndUserSession endUserSession, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ServerSessionCreateStep2(endUserSession.GetHandle(), byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public boolean SessionIsInitialized(EndUserSession endUserSession) throws Exception {
        this.CheckLibraryLoad();
        return this.library.SessionIsInitialized(endUserSession.GetHandle());
    }

    public byte[] SessionSave(EndUserSession endUserSession) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.SessionSave(endUserSession.GetHandle(), byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public EndUserSession SessionLoad(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        int n = this.library.SessionLoad(byArray, lArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSession(lArray[0], null);
    }

    public boolean SessionCheckCertificates(EndUserSession endUserSession) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SessionCheckCertificates(endUserSession.GetHandle());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return true;
    }

    public byte[] SessionEncrypt(EndUserSession endUserSession, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.SessionEncrypt(endUserSession.GetHandle(), byArray, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public String SessionEncrypt(EndUserSession endUserSession, String string) throws Exception {
        return this.BASE64Encode(this.SessionEncrypt(endUserSession, this.GetBytesFromString(string)));
    }

    public byte[] SessionEncryptContinue(EndUserSession endUserSession, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SessionEncryptContinue(endUserSession.GetHandle(), byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArray;
    }

    public String SessionEncryptContinue(EndUserSession endUserSession, String string) throws Exception {
        return this.BASE64Encode(this.SessionEncryptContinue(endUserSession, this.GetBytesFromString(string)));
    }

    public byte[] SessionDecrypt(EndUserSession endUserSession, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.SessionDecrypt(endUserSession.GetHandle(), byArray, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public byte[] SessionDecrypt(EndUserSession endUserSession, String string) throws Exception {
        return this.SessionDecrypt(endUserSession, this.BASE64Decode(string));
    }

    public byte[] SessionDecryptContinue(EndUserSession endUserSession, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SessionDecryptContinue(endUserSession.GetHandle(), byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArray;
    }

    public byte[] SessionDecryptContinue(EndUserSession endUserSession, String string) throws Exception {
        return this.SessionDecryptContinue(endUserSession, this.BASE64Decode(string));
    }

    public EndUserCertificateInfo SessionGetPeerCertificateInfo(EndUserSession endUserSession) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        String[] stringArray31 = new String[]{null};
        String[] stringArray32 = new String[]{null};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        boolean[] blArray5 = new boolean[]{false};
        int n = this.library.SessionGetPeerCertificateInfo(endUserSession.GetHandle(), stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, blArray2, nArray2, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, stringArray31, stringArray32, blArray3, blArray4, blArray5);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCertificateInfo(stringArray[0], stringArray3[0], stringArray2[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], blArray2[0], nArray2[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], stringArray31[0], stringArray32[0], blArray3[0], blArray4[0], blArray5[0]);
    }

    public void SaveCertificate(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SaveCertificate(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void RefreshFileStore(boolean bl) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.RefreshFileStore(bl);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserModeSettings CreateModeSettings() {
        return new EndUserModeSettings(false);
    }

    public EndUserModeSettings GetModeSettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.GetModeSettings(blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserModeSettings(blArray[0]);
    }

    public void SetModeSettings(EndUserModeSettings endUserModeSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetModeSettings(endUserModeSettings.GetOfflineMode());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void CheckCertificate(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.CheckCertificate(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserCertificateInfoEx EnumOwnCertificates(int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray31 = new String[]{null};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        String[] stringArray32 = new String[]{null};
        String[] stringArray33 = new String[]{null};
        String[] stringArray34 = new String[]{null};
        String[] stringArray35 = new String[]{null};
        String[] stringArray36 = new String[]{null};
        boolean[] blArray5 = new boolean[]{false};
        int[] nArray5 = new int[]{0};
        String[] stringArray37 = new String[]{null};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        String[] stringArray38 = new String[]{null};
        String[] stringArray39 = new String[]{null};
        int n2 = this.library.EnumOwnCertificates(n, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, blArray2, blArray3, blArray4, nArray2, stringArray31, nArray3, nArray4, stringArray32, stringArray33, stringArray34, stringArray35, stringArray36, blArray5, nArray5, stringArray37, nArray6, nArray7, stringArray38, stringArray39);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return new EndUserCertificateInfoEx(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], blArray2[0], blArray3[0], blArray4[0], nArray2[0], stringArray31[0], nArray3[0], nArray4[0], stringArray32[0], stringArray33[0], stringArray34[0], stringArray35[0], stringArray36[0], blArray5[0], nArray5[0], stringArray37[0], nArray6[0], nArray7[0], stringArray38[0], stringArray39[0]);
    }

    public EndUserCertificateInfoEx GetCertificateInfoEx(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray31 = new String[]{null};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        String[] stringArray32 = new String[]{null};
        String[] stringArray33 = new String[]{null};
        String[] stringArray34 = new String[]{null};
        String[] stringArray35 = new String[]{null};
        String[] stringArray36 = new String[]{null};
        boolean[] blArray5 = new boolean[]{false};
        int[] nArray5 = new int[]{0};
        String[] stringArray37 = new String[]{null};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        String[] stringArray38 = new String[]{null};
        String[] stringArray39 = new String[]{null};
        int n = this.library.GetCertificateInfoEx(string, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, blArray2, blArray3, blArray4, nArray2, stringArray31, nArray3, nArray4, stringArray32, stringArray33, stringArray34, stringArray35, stringArray36, blArray5, nArray5, stringArray37, nArray6, nArray7, stringArray38, stringArray39);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCertificateInfoEx(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], blArray2[0], blArray3[0], blArray4[0], nArray2[0], stringArray31[0], nArray3[0], nArray4[0], stringArray32[0], stringArray33[0], stringArray34[0], stringArray35[0], stringArray36[0], blArray5[0], nArray5[0], stringArray37[0], nArray6[0], nArray7[0], stringArray38[0], stringArray39[0]);
    }

    public EndUserReceiverCertificate[] GetReceiversCertificates() throws Exception {
        this.CheckLibraryLoad();
        String[][] stringArray = new String[][]{null, null};
        int n = this.library.GetReceiversCertificates(stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        EndUserReceiverCertificate[] endUserReceiverCertificateArray = new EndUserReceiverCertificate[stringArray[0].length];
        for (int i = 0; i < stringArray[0].length; ++i) {
            endUserReceiverCertificateArray[i] = new EndUserReceiverCertificate(stringArray[0][i], stringArray[1][i]);
        }
        return endUserReceiverCertificateArray;
    }

    public EndUserPrivateKeyInfo CreatePrivateKeyInfo() throws Exception {
        this.CheckLibraryLoad();
        return new EndUserPrivateKeyInfo();
    }

    public EndUserRequestInfo[] GeneratePrivateKey(boolean bl, int n, int n2, String string, int n3, int n4, boolean bl2, int n5, String string2, int n6, int n7, String string3, EndUserPrivateKeyInfo endUserPrivateKeyInfo, boolean bl3) throws Exception {
        ArrayList arrayList = this.GeneratePrivateKeyEx(bl, n, n2, string, false, n3, n4, bl2, n5, string2, n6, n7, string3, null, null, endUserPrivateKeyInfo, bl3);
        EndUserRequestInfo[] endUserRequestInfoArray = new EndUserRequestInfo[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            endUserRequestInfoArray[i] = (EndUserRequestInfo)arrayList.get(i);
        }
        return endUserRequestInfoArray;
    }

    public EndUserRequestInfo[] GeneratePrivateKey(int n, int n2, boolean bl, int n3, String string, int n4, int n5, String string2) throws Exception {
        return this.GeneratePrivateKey(true, 0, 0, "", n, n2, bl, n3, string, n4, n5, string2, null, false);
    }

    public EndUserRequestInfo[] GeneratePrivateKey(int n, int n2, String string, int n3, int n4, boolean bl, int n5, String string2, int n6, int n7, String string3) throws Exception {
        return this.GeneratePrivateKey(false, n, n2, string, n3, n4, bl, n5, string2, n6, n7, string3, null, false);
    }

    public EndUserRequestInfo[] GeneratePrivateKey(String string, int n, int n2, boolean bl, int n3, String string2, int n4, int n5, String string3, EndUserPrivateKeyInfo endUserPrivateKeyInfo) throws Exception {
        return this.GeneratePrivateKey(false, 0, 0, string, n, n2, bl, n3, string2, n4, n5, string3, endUserPrivateKeyInfo, true);
    }

    public EndUserRequestInfo GetCRInfo(byte[] byArray, int n, String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        boolean[] blArray3 = new boolean[]{false};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray4 = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        String[] stringArray22 = new String[]{null};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        boolean[] blArray5 = new boolean[]{false};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        int n2 = this.library.GetCRInfo(byArray, blArray, blArray2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, blArray3, sArray, sArray2, blArray4, sArray3, sArray4, nArray, nArray2, stringArray22, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, blArray5, nArray3, nArray4, stringArray29, stringArray30);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserRequestInfo(n, byArray, string, blArray[0], blArray2[0], stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], blArray3[0], sArray, sArray2, blArray4[0], sArray3, sArray4, nArray[0], nArray2[0], stringArray22[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], blArray5[0], nArray3[0], nArray4[0], stringArray29[0], stringArray30[0]);
    }

    public void ChangePrivateKeyPassword(int n, int n2, String string, String string2) throws Exception {
        int n3;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n3 = this.library.ChangePrivateKeyPasswordSilently(n, n2, string, string2))) {
            this.RaiseError(n3);
        }
    }

    public void ChangePrivateKeyPassword() throws Exception {
        int n;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n = this.library.ChangePrivateKeyPassword())) {
            this.RaiseError(n);
        }
    }

    public void BackupPrivateKey(int n, int n2, String string, int n3, int n4, String string2) throws Exception {
        int n5;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2)) || !EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n3), this.EnumKeyMediaDevices(n3, n4))) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n5 = this.library.BackupPrivateKeySilently(n, n2, string, n3, n4, string2))) {
            this.RaiseError(n5);
        }
    }

    public void BackupPrivateKey() throws Exception {
        int n;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n = this.library.BackupPrivateKey())) {
            this.RaiseError(n);
        }
    }

    public void DestroyPrivateKey(int n, int n2, String string) throws Exception {
        int n3;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n3 = this.library.DestroyPrivateKeySilently(n, n2, string))) {
            this.RaiseError(n3);
        }
    }

    public void DestroyPrivateKey() throws Exception {
        int n;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n = this.library.DestroyPrivateKey())) {
            this.RaiseError(n);
        }
    }

    public boolean IsHardwareKeyMedia(int n, int n2, String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n3 = this.library.IsHardwareKeyMediaSilently(n, n2, string, blArray);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
        return blArray[0];
    }

    public boolean IsHardwareKeyMedia() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.IsHardwareKeyMedia(blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public boolean IsPrivateKeyExists(int n, int n2, String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n3 = this.library.IsPrivateKeyExistsSilently(n, n2, string, blArray);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
        return blArray[0];
    }

    public boolean IsPrivateKeyExists() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.IsPrivateKeyExists(blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public void SaveCertificates(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SaveCertificates(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void SaveCRL(boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SaveCRL(bl, byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserCertificateInfoEx GetCertificateByEmail(String string, int n, int n2, Date date) throws Exception {
        this.CheckLibraryLoad();
        short[] sArray = new short[6];
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        sArray[0] = (short)date.getYear();
        sArray[1] = (short)date.getMonth();
        sArray[2] = (short)date.getDate();
        sArray[3] = (short)date.getHours();
        sArray[4] = (short)date.getMinutes();
        sArray[5] = (short)date.getSeconds();
        int n3 = this.library.GetCertificateByEmail(string, n, n2, sArray, stringArray, stringArray2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
        return this.GetCertificateInfoEx(stringArray[0], stringArray2[0]);
    }

    public EndUserCertificateInfoEx GetCertificateByEmail(String string, int n, int n2, String string2) throws Exception {
        String string3 = "dd/MM/yyyy HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        Date date = null;
        try {
            date = simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            this.RaiseError(2);
        }
        return this.GetCertificateByEmail(string, n, n2, date);
    }

    public EndUserCertificateInfoEx GetCertificateByNBUCode(String string, int n, int n2, Date date) throws Exception {
        this.CheckLibraryLoad();
        short[] sArray = new short[6];
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        sArray[0] = (short)date.getYear();
        sArray[1] = (short)date.getMonth();
        sArray[2] = (short)date.getDate();
        sArray[3] = (short)date.getHours();
        sArray[4] = (short)date.getMinutes();
        sArray[5] = (short)date.getSeconds();
        int n3 = this.library.GetCertificateByNBUCode(string, n, n2, sArray, stringArray, stringArray2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
        return this.GetCertificateInfoEx(stringArray[0], stringArray2[0]);
    }

    public EndUserCertificateInfoEx GetCertificateByNBUCode(String string, int n, int n2, String string2) throws Exception {
        String string3 = "dd/MM/yyyy HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        Date date = null;
        try {
            date = simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            this.RaiseError(2);
        }
        return this.GetCertificateByNBUCode(string, n, n2, date);
    }

    public String AppendSign(byte[] byArray, String string) throws Exception {
        String[] stringArray = new String[]{null};
        int n = this.library.AppendSign(byArray, string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String AppendSign(String string, String string2) throws Exception {
        return this.AppendSign(this.GetBytesFromString(string), string2);
    }

    public String AppendSignInternal(boolean bl, String string) throws Exception {
        String[] stringArray = new String[]{null};
        int n = this.library.AppendSignInternal(bl, string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String VerifySpecific(String string, byte[] byArray, int n, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.VerifySpecific(string, byArray, n, bl, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String VerifySpecific(String string, String string2, int n, boolean bl) throws Exception {
        return this.VerifySpecific(string, this.GetBytesFromString(string2), n, bl);
    }

    public EndUserSignInfo VerifySpecific(String string, byte[] byArray, int n) throws Exception {
        this.CheckLibraryLoad();
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetSignerInfo(n, string);
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.VerifySpecificEx(string, byArray, n, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public EndUserSignInfo VerifySpecific(String string, String string2, int n) throws Exception {
        return this.VerifySpecific(string, this.GetBytesFromString(string2), n);
    }

    public byte[] VerifySpecificInternal(String string, int n, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        int n2 = this.library.VerifySpecificInternal(string, n, byArrayArray, bl, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return byArrayArray[0];
    }

    public String VerifySpecificInternalString(String string, int n, boolean bl) throws Exception {
        return new String(this.VerifySpecificInternal(string, n, bl), this.charset);
    }

    public EndUserSignInfo VerifySpecificInternal(String string, int n) throws Exception {
        this.CheckLibraryLoad();
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetSignerInfo(n, string);
        byte[][] byArrayArray = new byte[][]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.VerifySpecificInternalEx(string, n, byArrayArray, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), byArrayArray[0]);
    }

    public void AppendSignBegin(String string) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.AppendSignBegin(string);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void VerifyDataSpecificBegin(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.VerifyDataSpecificBegin(n, string);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public void AppendSignFile(String string, String string2, String string3, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.AppendSignFile(string, string2, string3, bl);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String VerifyFileWithExternalSignSpecific(int n, String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.VerifyFileWithExternalSignSpecific(n, string, string2, bl, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyFileWithExternalSignSpecific(int n, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetFileSignerInfo(n, string2);
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.VerifyFileWithExternalSignSpecificEx(n, string, string2, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public String VerifyFileWithInternalSignSpecific(int n, String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.VerifyFileWithInternalSignSpecific(n, string, string2, bl, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyFileWithInternalSignSpecific(int n, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetFileSignerInfo(n, string);
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.VerifyFileWithInternalSignSpecificEx(n, string, string2, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public String AppendSignHash(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.AppendSignHash(string, string2, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String VerifyHashSpecific(String string, int n, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.VerifyHashSpecific(string, n, string2, bl, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyHashSpecific(String string, int n, String string2) throws Exception {
        this.CheckLibraryLoad();
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetSignerInfo(n, string2);
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.VerifyHashSpecificEx(string, n, string2, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public int GetSignsCount(String string) throws Exception {
        this.CheckLibraryLoad();
        int[] nArray = new int[]{0};
        int n = this.library.GetSignsCount(string, nArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return nArray[0];
    }

    public EndUserCertificateInfoEx GetSignerInfo(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray31 = new String[]{null};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        String[] stringArray32 = new String[]{null};
        String[] stringArray33 = new String[]{null};
        String[] stringArray34 = new String[]{null};
        String[] stringArray35 = new String[]{null};
        String[] stringArray36 = new String[]{null};
        boolean[] blArray5 = new boolean[]{false};
        int[] nArray5 = new int[]{0};
        String[] stringArray37 = new String[]{null};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        String[] stringArray38 = new String[]{null};
        String[] stringArray39 = new String[]{null};
        int n2 = this.library.GetSignerInfo(n, string, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, blArray2, blArray3, blArray4, nArray2, stringArray31, nArray3, nArray4, stringArray32, stringArray33, stringArray34, stringArray35, stringArray36, blArray5, nArray5, stringArray37, nArray6, nArray7, stringArray38, stringArray39);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserCertificateInfoEx(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], blArray2[0], blArray3[0], blArray4[0], nArray2[0], stringArray31[0], nArray3[0], nArray4[0], stringArray32[0], stringArray33[0], stringArray34[0], stringArray35[0], stringArray36[0], blArray5[0], nArray5[0], stringArray37[0], nArray6[0], nArray7[0], stringArray38[0], stringArray39[0]);
    }

    public byte[] GetSignerCertificate(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.GetSignerCertificate(n, string, byArrayArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return byArrayArray[0];
    }

    public int GetFileSignsCount(String string) throws Exception {
        this.CheckLibraryLoad();
        int[] nArray = new int[]{0};
        int n = this.library.GetFileSignsCount(string, nArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return nArray[0];
    }

    public EndUserCertificateInfoEx GetFileSignerInfo(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray31 = new String[]{null};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        String[] stringArray32 = new String[]{null};
        String[] stringArray33 = new String[]{null};
        String[] stringArray34 = new String[]{null};
        String[] stringArray35 = new String[]{null};
        String[] stringArray36 = new String[]{null};
        boolean[] blArray5 = new boolean[]{false};
        int[] nArray5 = new int[]{0};
        String[] stringArray37 = new String[]{null};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        String[] stringArray38 = new String[]{null};
        String[] stringArray39 = new String[]{null};
        int n2 = this.library.GetFileSignerInfo(n, string, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, blArray2, blArray3, blArray4, nArray2, stringArray31, nArray3, nArray4, stringArray32, stringArray33, stringArray34, stringArray35, stringArray36, blArray5, nArray5, stringArray37, nArray6, nArray7, stringArray38, stringArray39);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserCertificateInfoEx(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], blArray2[0], blArray3[0], blArray4[0], nArray2[0], stringArray31[0], nArray3[0], nArray4[0], stringArray32[0], stringArray33[0], stringArray34[0], stringArray35[0], stringArray36[0], blArray5[0], nArray5[0], stringArray37[0], nArray6[0], nArray7[0], stringArray38[0], stringArray39[0]);
    }

    public byte[] GetFileSignerCertificate(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.GetFileSignerCertificate(n, string, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return byArrayArray[0];
    }

    public boolean IsAlreadySigned(String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.IsAlreadySigned(string, blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public boolean IsFileAlreadySigned(String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.IsFileAlreadySigned(string, blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public String HashWithParams(byte[] byArray, byte[] byArray2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.HashWithParams(byArray, byArray2, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String HashWithParams(byte[] byArray, String string) throws Exception {
        return this.HashWithParams(byArray, this.GetBytesFromString(string));
    }

    public void HashBeginWithParams(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.HashBeginWithParams(byArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String HashFileWithParams(byte[] byArray, String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.HashFileWithParams(byArray, string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public ArrayList GetReceiversCertificatesInArrayList() throws Exception {
        ArrayList<EndUserReceiverCertificate> arrayList = new ArrayList<EndUserReceiverCertificate>();
        EndUserReceiverCertificate[] endUserReceiverCertificateArray = this.GetReceiversCertificates();
        for (int i = 0; i < endUserReceiverCertificateArray.length; ++i) {
            arrayList.add(endUserReceiverCertificateArray[i]);
        }
        return arrayList;
    }

    public ArrayList GeneratePrivateKeyEx(boolean bl, int n, int n2, String string, int n3, int n4, boolean bl2, int n5, String string2, int n6, int n7, String string3, EndUserPrivateKeyInfo endUserPrivateKeyInfo, boolean bl3) throws Exception {
        return this.GeneratePrivateKeyEx(bl, n, n2, string, false, n3, n4, bl2, n5, string2, n6, n7, string3, null, null, endUserPrivateKeyInfo, bl3);
    }

    public ArrayList GeneratePrivateKeyEx(int n, int n2, boolean bl, int n3, String string, int n4, int n5, String string2) throws Exception {
        return this.GeneratePrivateKeyEx(true, 0, 0, "", false, n, n2, bl, n3, string, n4, n5, string2, null, null, null, false);
    }

    public ArrayList GeneratePrivateKeyEx(int n, int n2, String string, int n3, int n4, boolean bl, int n5, String string2, int n6, int n7, String string3) throws Exception {
        return this.GeneratePrivateKeyEx(false, n, n2, string, false, n3, n4, bl, n5, string2, n6, n7, string3, null, null, null, false);
    }

    public ArrayList GeneratePrivateKeyEx(String string, int n, int n2, boolean bl, int n3, String string2, int n4, int n5, String string3, EndUserPrivateKeyInfo endUserPrivateKeyInfo) throws Exception {
        return this.GeneratePrivateKeyEx(false, 0, 0, string, false, n, n2, bl, n3, string2, n4, n5, string3, null, null, endUserPrivateKeyInfo, true);
    }

    public EndUserInfo CreateEndUserInfo() throws Exception {
        this.CheckLibraryLoad();
        return new EndUserInfo();
    }

    public ArrayList GeneratePrivateKeyEx(boolean bl, int n, int n2, String string, boolean bl2, int n3, int n4, boolean bl3, int n5, String string2, int n6, int n7, String string3, EndUserInfo endUserInfo, String string4, EndUserPrivateKeyInfo endUserPrivateKeyInfo, boolean bl4) throws Exception {
        EndUserRequestInfo endUserRequestInfo;
        int n8;
        this.CheckLibraryLoad();
        if (bl4) {
            if (!EndUserKeyMediaAccessChecker.IsBinaryKeyPermitted()) {
                this.RaiseError(18);
            }
        } else if (bl) {
            if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
                this.RaiseError(18);
            }
        } else if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        Object object = new byte[][]{null};
        Object object2 = new byte[][]{null};
        Object object3 = new byte[][]{null};
        Object object4 = new byte[][]{null};
        Object object5 = new byte[][]{null};
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        ArrayList<EndUserRequestInfo> arrayList = new ArrayList<EndUserRequestInfo>();
        if (endUserPrivateKeyInfo == null) {
            object = null;
            object2 = null;
        } else if (!bl4) {
            object = null;
        }
        if (n3 == 0) {
            object3 = null;
            stringArray = null;
            object4 = null;
            stringArray2 = null;
        } else if (bl3) {
            object4 = null;
            stringArray2 = null;
        }
        if (n6 == 0) {
            object5 = null;
            stringArray3 = null;
        }
        if (EndUserError.isError(n8 = this.library.GeneratePrivateKey(bl, n, n2, string, bl2, n3, n4, n5, string2, n6, n7, string3, endUserInfo != null, endUserInfo != null ? endUserInfo.GetCommonName() : null, endUserInfo != null ? endUserInfo.GetLocality() : null, endUserInfo != null ? endUserInfo.GetState() : null, endUserInfo != null ? endUserInfo.GetOrganization() : null, endUserInfo != null ? endUserInfo.GetOrgUnit() : null, endUserInfo != null ? endUserInfo.GetTitle() : null, endUserInfo != null ? endUserInfo.GetStreet() : null, endUserInfo != null ? endUserInfo.GetPhone() : null, endUserInfo != null ? endUserInfo.GetSurname() : null, endUserInfo != null ? endUserInfo.GetGivenname() : null, endUserInfo != null ? endUserInfo.GetEMail() : null, endUserInfo != null ? endUserInfo.GetDNS() : null, endUserInfo != null ? endUserInfo.GetEDRPOUCode() : null, endUserInfo != null ? endUserInfo.GetDRFOCode() : null, endUserInfo != null ? endUserInfo.GetNBUCode() : null, endUserInfo != null ? endUserInfo.GetSPFMCode() : null, endUserInfo != null ? endUserInfo.GetOCode() : null, endUserInfo != null ? endUserInfo.GetOUCode() : null, endUserInfo != null ? endUserInfo.GetUserCode() : null, endUserInfo != null ? endUserInfo.GetUPN() : null, endUserInfo != null ? endUserInfo.GetUNZR() : null, endUserInfo != null ? endUserInfo.GetCountry() : null, string4, (byte[][])object, (byte[][])object2, (byte[][])object3, stringArray, (byte[][])object4, stringArray2, (byte[][])object5, stringArray3))) {
            this.RaiseError(n8);
        }
        if (endUserPrivateKeyInfo != null) {
            if (bl4) {
                endUserPrivateKeyInfo.SetPrivateKey(object[0]);
            }
            endUserPrivateKeyInfo.SetPrivateKeyInfo(object2[0]);
        }
        if (n3 != 0) {
            endUserRequestInfo = this.GetCRInfo(object3[0], 1, stringArray[0]);
            arrayList.add(endUserRequestInfo);
            if (!bl3 && object4[0] != null) {
                endUserRequestInfo = this.GetCRInfo(object4[0], 2, stringArray2[0]);
                arrayList.add(endUserRequestInfo);
            }
        }
        if (n6 != 0) {
            endUserRequestInfo = this.GetCRInfo(object5[0], 3, stringArray3[0]);
            arrayList.add(endUserRequestInfo);
        }
        return arrayList;
    }

    public ArrayList GeneratePrivateKeyEx(int n, int n2, boolean bl, int n3, String string, int n4, int n5, String string2, EndUserInfo endUserInfo, String string3) throws Exception {
        return this.GeneratePrivateKeyEx(true, 0, 0, "", false, n, n2, bl, n3, string, n4, n5, string2, endUserInfo, string3, null, false);
    }

    public ArrayList GeneratePrivateKeyEx(int n, int n2, String string, boolean bl, int n3, int n4, boolean bl2, int n5, String string2, int n6, int n7, String string3, EndUserInfo endUserInfo, String string4) throws Exception {
        return this.GeneratePrivateKeyEx(false, n, n2, string, bl, n3, n4, bl2, n5, string2, n6, n7, string3, endUserInfo, string4, null, false);
    }

    public ArrayList GeneratePrivateKeyEx(String string, int n, int n2, boolean bl, int n3, String string2, int n4, int n5, String string3, EndUserInfo endUserInfo, String string4, EndUserPrivateKeyInfo endUserPrivateKeyInfo) throws Exception {
        return this.GeneratePrivateKeyEx(false, 0, 0, string, false, n, n2, bl, n3, string2, n4, n5, string3, endUserInfo, string4, endUserPrivateKeyInfo, true);
    }

    public String BytesToString(byte[] byArray) throws Exception {
        return this.SetBytesToString(byArray);
    }

    public void SetKeyMediaPassword(int n, int n2, String string) throws Exception {
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        int[] nArray = new int[]{0};
        int n3 = this.library.SetKeyMediaPasswordSilently(n, n2, string);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void SetKeyMediaPassword() throws Exception {
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsSelectKeyMediaPermitted()) {
            this.RaiseError(18);
        }
        int[] nArray = new int[]{0};
        int n = this.library.SetKeyMediaPassword();
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String GetLastError() {
        return this.lastError;
    }

    public int GetLastErrorCode() {
        return this.lastErrorCode;
    }

    public String EnvelopEx(ArrayList arrayList, ArrayList arrayList2, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EnvelopEx(this.ArrayListToStringArray(arrayList), this.ArrayListToStringArray(arrayList2), bl, byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String EnvelopEx(ArrayList arrayList, ArrayList arrayList2, boolean bl, String string) throws Exception {
        return this.EnvelopEx(arrayList, arrayList2, bl, this.GetBytesFromString(string));
    }

    public void EnvelopFileEx(ArrayList arrayList, ArrayList arrayList2, boolean bl, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.EnvelopFileEx(this.ArrayListToStringArray(arrayList), this.ArrayListToStringArray(arrayList2), bl, string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String EnvelopToRecipients(ArrayList arrayList, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EnvelopToRecipients(this.ArrayListToByteArray(arrayList), bl, byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String EnvelopToRecipients(ArrayList arrayList, boolean bl, String string) throws Exception {
        return this.EnvelopToRecipients(arrayList, bl, this.GetBytesFromString(string));
    }

    public void EnvelopFileToRecipients(ArrayList arrayList, boolean bl, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.EnvelopFileToRecipients(this.ArrayListToByteArray(arrayList), bl, string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String EnvelopExWithDynamicKey(ArrayList arrayList, ArrayList arrayList2, boolean bl, boolean bl2, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EnvelopExWithDynamicKey(this.ArrayListToStringArray(arrayList), this.ArrayListToStringArray(arrayList2), bl, bl2, byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String EnvelopExWithDynamicKey(ArrayList arrayList, ArrayList arrayList2, boolean bl, boolean bl2, String string) throws Exception {
        return this.EnvelopExWithDynamicKey(arrayList, arrayList2, bl, bl2, this.GetBytesFromString(string));
    }

    public void EnvelopFileExWithDynamicKey(ArrayList arrayList, ArrayList arrayList2, boolean bl, boolean bl2, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.EnvelopFileExWithDynamicKey(this.ArrayListToStringArray(arrayList), this.ArrayListToStringArray(arrayList2), bl, bl2, string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String EnvelopToRecipientsWithDynamicKey(ArrayList arrayList, boolean bl, boolean bl2, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EnvelopToRecipientsWithDynamicKey(this.ArrayListToByteArray(arrayList), bl, bl2, byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String EnvelopToRecipientsWithDynamicKey(ArrayList arrayList, boolean bl, boolean bl2, String string) throws Exception {
        return this.EnvelopToRecipientsWithDynamicKey(arrayList, bl, bl2, this.GetBytesFromString(string));
    }

    public void EnvelopFileToRecipientsWithDynamicKey(ArrayList arrayList, boolean bl, boolean bl2, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.EnvelopFileToRecipientsWithDynamicKey(this.ArrayListToByteArray(arrayList), bl, bl2, string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public ArrayList CreateArrayList() throws Exception {
        return new ArrayList();
    }

    public String CreateEmptySign(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.CreateEmptySign(byArray, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String CreateEmptySign(String string) throws Exception {
        return this.CreateEmptySign(this.GetBytesFromString(string));
    }

    public String CreateEmptySign() throws Exception {
        return this.CreateEmptySign((byte[])null);
    }

    public String CreateSigner(String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.CreateSigner(string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSigner CreateSignerBegin(byte[] byArray, byte[] byArray2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        byte[][] byArrayArray2 = new byte[][]{null};
        int n = this.library.CreateSignerBegin(byArray, byArray2, byArrayArray, byArrayArray2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSigner(byArrayArray[0], byArrayArray2[0]);
    }

    public String CreateSignerEnd(byte[] byArray, byte[] byArray2) throws Exception {
        String string;
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.CreateSignerEnd(byArray, byArray2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        if ((string = this.BASE64Encode(byArrayArray[0])) == null) {
            this.RaiseError(6);
        }
        return string;
    }

    public String AppendSigner(String string, byte[] byArray, String string2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.AppendSigner(string, byArray, string2, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String EnvelopToRecipientsEx(ArrayList arrayList, int n, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnvelopToRecipientsEx(this.ArrayListToByteArray(arrayList), n, bl, byArray, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String EnvelopToRecipientsEx(ArrayList arrayList, int n, boolean bl, String string) throws Exception {
        return this.EnvelopToRecipientsEx(arrayList, n, bl, this.GetBytesFromString(string));
    }

    public void EnvelopFileToRecipientsEx(ArrayList arrayList, int n, boolean bl, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.EnvelopFileToRecipientsEx(this.ArrayListToByteArray(arrayList), n, bl, string, string2);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public String EnvelopToRecipientsWithOCode(String string, int n, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnvelopToRecipientsWithOCode(string, n, bl, byArray, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String EnvelopToRecipientsWithOCode(String string, int n, boolean bl, String string2) throws Exception {
        return this.EnvelopToRecipientsWithOCode(string, n, bl, this.GetBytesFromString(string2));
    }

    public EndUserOperationContext ContinueSignCtx(EndUserOperationContext endUserOperationContext, byte[] byArray) throws Exception {
        int n;
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        if (endUserOperationContext != null) {
            lArray[0] = endUserOperationContext.GetHandle();
        }
        if (EndUserError.isError(n = this.library.ContinueSignCtxWithOffset(lArray, byArray, 0, byArray.length))) {
            this.RaiseError(n);
        }
        if (endUserOperationContext != null) {
            return endUserOperationContext;
        }
        return new EndUserOperationContext(lArray[0]);
    }

    public EndUserOperationContext ContinueSignCtxWithOffset(EndUserOperationContext endUserOperationContext, byte[] byArray, int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        if (endUserOperationContext != null) {
            // empty if block
        }
        lArray[0] = endUserOperationContext.GetHandle();
        int n3 = this.library.ContinueSignCtxWithOffset(lArray, byArray, n, n2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
        if (endUserOperationContext != null) {
            return endUserOperationContext;
        }
        return new EndUserOperationContext(lArray[0]);
    }

    public EndUserOperationContext ContinueSignCtx(EndUserOperationContext endUserOperationContext, String string) throws Exception {
        return this.ContinueSignCtx(endUserOperationContext, this.GetBytesFromString(string));
    }

    public String EndSignCtx(EndUserOperationContext endUserOperationContext, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndSignCtx(endUserOperationContext.GetHandle(), bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserOperationContext BeginVerifyCtx(String string) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        int n = this.library.BeginVerifyCtx(string, lArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserOperationContext(lArray[0]);
    }

    public void ContinueVerifyCtx(EndUserOperationContext endUserOperationContext, byte[] byArray, int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        int n3 = this.library.ContinueVerifyCtxWithOffset(endUserOperationContext.GetHandle(), byArray, n, n2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void ContinueVerifyCtx(EndUserOperationContext endUserOperationContext, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ContinueVerifyCtxWithOffset(endUserOperationContext.GetHandle(), byArray, 0, byArray.length);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void ContinueVerifyCtx(EndUserOperationContext endUserOperationContext, String string) throws Exception {
        this.ContinueVerifyCtx(endUserOperationContext, this.GetBytesFromString(string));
    }

    public String EndVerifyCtx(EndUserOperationContext endUserOperationContext, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndVerifyCtx(endUserOperationContext.GetHandle(), bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserSignInfo EndVerifyCtx(EndUserOperationContext endUserOperationContext) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n = this.library.EndVerifyCtxEx(endUserOperationContext.GetHandle(), stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, blArray, blArray2, sArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0]), new EndUserTimeInfo(blArray[0], blArray2[0], sArray), null);
    }

    public void ResetOperationCtx(EndUserOperationContext endUserOperationContext) throws Exception {
        this.CheckLibraryLoad();
        this.library.ResetOperationCtx(endUserOperationContext.GetHandle());
    }

    public String SignRSA(byte[] byArray, boolean bl, boolean bl2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.SignRSA(byArray, bl, bl2, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String SignRSA(String string, boolean bl, boolean bl2) throws Exception {
        return this.SignRSA(this.GetBytesFromString(string), bl, bl2);
    }

    public void ContinueRSASign(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.ContinueRSASignWithOffset(byArray, 0, byArray.length);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void ContinueRSASignWithOffset(byte[] byArray, int n, int n2) throws Exception {
        this.CheckLibraryLoad();
        int n3 = this.library.ContinueRSASignWithOffset(byArray, n, n2);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void ContinueRSASign(String string) throws Exception {
        this.ContinueRSASign(this.GetBytesFromString(string));
    }

    public String EndRSASign(boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndRSASign(bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public void SignRSAFile(String string, String string2, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SignRSAFile(string, string2, bl);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserOperationContext ContinueRSASignCtx(EndUserOperationContext endUserOperationContext, byte[] byArray) throws Exception {
        int n;
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        if (endUserOperationContext != null) {
            lArray[0] = endUserOperationContext.GetHandle();
        }
        if (EndUserError.isError(n = this.library.ContinueRSASignCtxWithOffset(lArray, byArray, 0, byArray.length))) {
            this.RaiseError(n);
        }
        if (endUserOperationContext != null) {
            return endUserOperationContext;
        }
        return new EndUserOperationContext(lArray[0]);
    }

    public EndUserOperationContext ContinueRSASignCtxWithOffset(EndUserOperationContext endUserOperationContext, byte[] byArray, int n, int n2) throws Exception {
        int n3;
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        if (endUserOperationContext != null) {
            lArray[0] = endUserOperationContext.GetHandle();
        }
        if (EndUserError.isError(n3 = this.library.ContinueRSASignCtxWithOffset(lArray, byArray, n, n2))) {
            this.RaiseError(n3);
        }
        if (endUserOperationContext != null) {
            return endUserOperationContext;
        }
        return new EndUserOperationContext(lArray[0]);
    }

    public EndUserOperationContext ContinueRSASignCtx(EndUserOperationContext endUserOperationContext, String string) throws Exception {
        return this.ContinueRSASignCtx(endUserOperationContext, this.GetBytesFromString(string));
    }

    public String EndRSASignCtx(EndUserOperationContext endUserOperationContext, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.EndRSASignCtx(endUserOperationContext.GetHandle(), bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public byte[] GetCertificateByKeyInfo(int n, int n2) throws Exception {
        byte[][] byArrayArray;
        int n3;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n3 = this.library.GetCertificateByKeyInfo(n, n2, null, byArrayArray = new byte[][]{null}))) {
            this.RaiseError(n3);
        }
        return byArrayArray[0];
    }

    public byte[] GetCertificateByKeyInfo(byte[] byArray) throws Exception {
        byte[][] byArrayArray;
        int n;
        this.CheckLibraryLoad();
        if (byArray == null) {
            this.RaiseError(2);
        }
        if (EndUserError.isError(n = this.library.GetCertificateByKeyInfo(0, 0, byArray, byArrayArray = new byte[][]{null}))) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public EndUserPrivateKeyInfo GetKeyInfoSilently(int n, int n2, String string) throws Exception {
        byte[][] byArrayArray;
        int n3;
        this.CheckLibraryLoad();
        if (!EndUserKeyMediaAccessChecker.IsKeyMediaPermitted(this.EnumKeyMediaTypes(n), this.EnumKeyMediaDevices(n, n2))) {
            this.RaiseError(18);
        }
        if (EndUserError.isError(n3 = this.library.GetKeyInfo(n, n2, string, byArrayArray = new byte[][]{null}))) {
            this.RaiseError(n3);
        }
        return new EndUserPrivateKeyInfo(null, byArrayArray[0]);
    }

    public EndUserPrivateKeyInfo GetKeyInfo(EndUserKeyMedia endUserKeyMedia) throws Exception {
        return this.GetKeyInfoSilently(endUserKeyMedia.GetTypeIndex(), endUserKeyMedia.GetDevIndex(), endUserKeyMedia.GetPassword());
    }

    public EndUserPrivateKeyInfo GetKeyInfoBinary(byte[] byArray, String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.GetKeyInfoBinary(byArray, string, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserPrivateKeyInfo(null, byArrayArray[0]);
    }

    public EndUserPrivateKeyInfo GetKeyInfoFile(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.GetKeyInfoFile(string, string2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserPrivateKeyInfo(null, byArrayArray[0]);
    }

    public byte[] GetCertificatesByKeyInfo(byte[] byArray, ArrayList arrayList, ArrayList arrayList2) throws Exception {
        int n;
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (arrayList != null && arrayList2 != null && arrayList.size() != 0 && arrayList2.size() != 0) {
            stringArray = this.ArrayListToStringArray(arrayList);
            stringArray2 = this.ArrayListToStringArray(arrayList2);
        }
        if (EndUserError.isError(n = this.library.GetCertificatesByKeyInfo(byArray, stringArray, stringArray2, byArrayArray))) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public byte[] GetCertificatesByKeyInfo(EndUserPrivateKeyInfo endUserPrivateKeyInfo, ArrayList arrayList, ArrayList arrayList2) throws Exception {
        return this.GetCertificatesByKeyInfo(endUserPrivateKeyInfo.GetPrivateKeyInfo(), arrayList, arrayList2);
    }

    public void SetRuntimeParameter(String string, boolean bl) throws Exception {
        this.SetRuntimeParameter(string, bl ? 1 : 0);
    }

    public void SetRuntimeParameter(String string, int n) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.SetRuntimeParameterInt(string, n);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public String GetStorageParameter(boolean bl, String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.GetStorageParameter(bl, string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public void SetStorageParameter(boolean bl, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetStorageParameter(bl, string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserOCSPAccessInfoModeSettings CreateOCSPAccessInfoModeSettings() {
        return new EndUserOCSPAccessInfoModeSettings(false);
    }

    public EndUserOCSPAccessInfoModeSettings GetOCSPAccessInfoModeSettings() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.GetOCSPAccessInfoModeSettings(blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserOCSPAccessInfoModeSettings(blArray[0]);
    }

    public void SetOCSPAccessInfoModeSettings(EndUserOCSPAccessInfoModeSettings endUserOCSPAccessInfoModeSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetOCSPAccessInfoModeSettings(endUserOCSPAccessInfoModeSettings.GetEnabled());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public EndUserOCSPAccessInfoSettings CreateOCSPAccessInfoSettings() {
        return new EndUserOCSPAccessInfoSettings("", "", "");
    }

    public EndUserOCSPAccessInfoSettings EnumOCSPAccessInfoSettings(int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        int n2 = this.library.EnumOCSPAccessInfoSettings(n, stringArray, stringArray2, stringArray3);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return new EndUserOCSPAccessInfoSettings(stringArray[0], stringArray2[0], stringArray3[0]);
    }

    public EndUserOCSPAccessInfoSettings GetOCSPAccessInfoSettings(String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        int n = this.library.GetOCSPAccessInfoSettings(string, stringArray, stringArray2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserOCSPAccessInfoSettings(string, stringArray[0], stringArray2[0]);
    }

    public void SetOCSPAccessInfoSettings(EndUserOCSPAccessInfoSettings endUserOCSPAccessInfoSettings) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetOCSPAccessInfoSettings(endUserOCSPAccessInfoSettings.GetIssuerCN(), endUserOCSPAccessInfoSettings.GetAddress(), endUserOCSPAccessInfoSettings.GetPort());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void DeleteOCSPAccessInfoSettings(String string) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.DeleteOCSPAccessInfoSettings(string);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public byte[] CheckCertificateByIssuerAndSerial(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.CheckCertificateByIssuerAndSerial(string, string2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public EndUserCertificateInfoEx ParseCertificateEx(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        String[] stringArray2 = new String[]{null};
        String[] stringArray3 = new String[]{null};
        String[] stringArray4 = new String[]{null};
        String[] stringArray5 = new String[]{null};
        String[] stringArray6 = new String[]{null};
        String[] stringArray7 = new String[]{null};
        String[] stringArray8 = new String[]{null};
        String[] stringArray9 = new String[]{null};
        String[] stringArray10 = new String[]{null};
        String[] stringArray11 = new String[]{null};
        String[] stringArray12 = new String[]{null};
        String[] stringArray13 = new String[]{null};
        String[] stringArray14 = new String[]{null};
        String[] stringArray15 = new String[]{null};
        String[] stringArray16 = new String[]{null};
        String[] stringArray17 = new String[]{null};
        String[] stringArray18 = new String[]{null};
        String[] stringArray19 = new String[]{null};
        String[] stringArray20 = new String[]{null};
        String[] stringArray21 = new String[]{null};
        String[] stringArray22 = new String[]{null};
        short[] sArray = new short[6];
        short[] sArray2 = new short[6];
        boolean[] blArray = new boolean[]{false};
        short[] sArray3 = new short[6];
        short[] sArray4 = new short[6];
        int[] nArray = new int[]{0};
        String[] stringArray23 = new String[]{null};
        String[] stringArray24 = new String[]{null};
        String[] stringArray25 = new String[]{null};
        String[] stringArray26 = new String[]{null};
        String[] stringArray27 = new String[]{null};
        String[] stringArray28 = new String[]{null};
        String[] stringArray29 = new String[]{null};
        String[] stringArray30 = new String[]{null};
        boolean[] blArray2 = new boolean[]{false};
        boolean[] blArray3 = new boolean[]{false};
        boolean[] blArray4 = new boolean[]{false};
        int[] nArray2 = new int[]{0};
        String[] stringArray31 = new String[]{null};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        String[] stringArray32 = new String[]{null};
        String[] stringArray33 = new String[]{null};
        String[] stringArray34 = new String[]{null};
        String[] stringArray35 = new String[]{null};
        String[] stringArray36 = new String[]{null};
        boolean[] blArray5 = new boolean[]{false};
        int[] nArray5 = new int[]{0};
        String[] stringArray37 = new String[]{null};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        String[] stringArray38 = new String[]{null};
        String[] stringArray39 = new String[]{null};
        int n = this.library.ParseCertificateEx(byArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, stringArray18, stringArray19, stringArray20, stringArray21, stringArray22, sArray, sArray2, blArray, sArray3, sArray4, nArray, stringArray23, stringArray24, stringArray25, stringArray26, stringArray27, stringArray28, stringArray29, stringArray30, blArray2, blArray3, blArray4, nArray2, stringArray31, nArray3, nArray4, stringArray32, stringArray33, stringArray34, stringArray35, stringArray36, blArray5, nArray5, stringArray37, nArray6, nArray7, stringArray38, stringArray39);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCertificateInfoEx(stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], stringArray8[0], stringArray9[0], stringArray10[0], stringArray11[0], stringArray12[0], stringArray13[0], stringArray14[0], stringArray15[0], stringArray16[0], stringArray17[0], stringArray18[0], stringArray19[0], stringArray20[0], stringArray21[0], stringArray22[0], sArray, sArray2, blArray[0], sArray3, sArray4, nArray[0], stringArray23[0], stringArray24[0], stringArray25[0], stringArray26[0], stringArray27[0], stringArray28[0], stringArray29[0], stringArray30[0], blArray2[0], blArray3[0], blArray4[0], nArray2[0], stringArray31[0], nArray3[0], nArray4[0], stringArray32[0], stringArray33[0], stringArray34[0], stringArray35[0], stringArray36[0], blArray5[0], nArray5[0], stringArray37[0], nArray6[0], nArray7[0], stringArray38[0], stringArray39[0]);
    }

    public EndUserSession ClientDynamicKeySessionCreate(int n, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.ClientDynamicKeySessionCreate(n, string, string2, null, lArray, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSession(lArray[0], byArrayArray[0]);
    }

    public EndUserSession ClientDynamicKeySessionCreate(int n, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.ClientDynamicKeySessionCreate(n, null, null, byArray, lArray, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSession(lArray[0], byArrayArray[0]);
    }

    public EndUserSession ServerDynamicKeySessionCreate(int n, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        int n2 = this.library.ServerDynamicKeySessionCreate(n, byArray, lArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserSession(lArray[0], null);
    }

    public byte[] AppendTransportHeader(String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.AppendTransportHeader(string, string2, string3, byArray, byArray2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public EndUserTransportHeader ParseTransportHeader(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        int[] nArray = new int[]{0};
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.ParseTransportHeader(byArray, nArray, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserTransportHeader(nArray[0], byArrayArray[0]);
    }

    public byte[] AppendCryptoHeader(String string, int n, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.AppendCryptoHeader(string, n, byArray, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return byArrayArray[0];
    }

    public EndUserCryptoHeader ParseCryptoHeader(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.ParseCryptoHeader(byArray, stringArray, nArray, nArray2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserCryptoHeader(stringArray[0], nArray[0], nArray2[0], byArrayArray[0]);
    }

    public boolean SCClientIsRunning() throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.SCClientIsRunning(blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public void SCClientStart() throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SCClientStart();
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void SCClientStop() throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SCClientStop();
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void SCClientAddGate(String string, int n, String string2, int n2, String string3, String string4) throws Exception {
        this.CheckLibraryLoad();
        int n3 = this.library.SCClientAddGate(string, n, string2, n2, string3, string4);
        if (EndUserError.isError(n3)) {
            this.RaiseError(n3);
        }
    }

    public void SCClientAddGate(String string, int n, String string2, int n2) throws Exception {
        this.SCClientAddGate(string, n, string2, n2, null, null);
    }

    public void SCClientRemoveGate(int n) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.SCClientRemoveGate(n);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public EndUserSCClientStatistic SCClientGetStatistic() throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long[] lArray3 = new long[]{0L};
        long[] lArray4 = new long[]{0L};
        int n = this.library.SCClientGetStatistic(lArray, lArray2, lArray3, lArray4);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSCClientStatistic(lArray[0], lArray2[0], lArray3[0], lArray4[0]);
    }

    public String EnumJKSPrivateKeys(byte[] byArray, int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnumJKSPrivateKeys(byArray, n, stringArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return stringArray[0];
    }

    public String EnumJKSPrivateKeysFile(String string, int n) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnumJKSPrivateKeysFile(string, n, stringArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return stringArray[0];
    }

    public EndUserJKSPrivateKey GetJKSPrivateKey(byte[] byArray, String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        byte[][][] byArrayArray2 = new byte[][][]{(byte[][])null};
        int n = this.library.GetJKSPrivateKey(byArray, string, byArrayArray, byArrayArray2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserJKSPrivateKey(byArrayArray[0], byArrayArray2[0]);
    }

    public EndUserJKSPrivateKey GetJKSPrivateKeyFile(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        byte[][][] byArrayArray2 = new byte[][][]{(byte[][])null};
        int n = this.library.GetJKSPrivateKeyFile(string, string2, byArrayArray, byArrayArray2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserJKSPrivateKey(byArrayArray[0], byArrayArray2[0]);
    }

    public boolean IsDataInSignedDataAvailable(String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.IsDataInSignedDataAvailable(string, blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public boolean IsDataInSignedFileAvailable(String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        int n = this.library.IsDataInSignedFileAvailable(string, blArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return blArray[0];
    }

    public byte[] GetDataFromSignedData(String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.GetDataFromSignedData(string, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public void GetDataFromSignedFile(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.GetDataFromSignedFile(string, string2);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public byte[] GetCertificateFromSignedData(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.GetCertificateFromSignedData(n, string, null, byArrayArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return byArrayArray[0];
    }

    public byte[] GetCertificateFromSignedData(int n, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.GetCertificateFromSignedData(n, null, byArray, byArrayArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return byArrayArray[0];
    }

    public byte[] GetCertificateFromSignedFile(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.GetCertificateFromSignedFile(n, string, byArrayArray);
        if (EndUserError.isError(n2)) {
            if (n2 != 7) {
                this.RaiseError(n2);
            } else {
                return null;
            }
        }
        return byArrayArray[0];
    }

    public byte[] GetCertificatesFromLDAPByEDRPOUCode(String string, int n, int n2, ArrayList arrayList, ArrayList arrayList2) throws Exception {
        int n3;
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (arrayList != null && arrayList2 != null && arrayList.size() != 0 && arrayList2.size() != 0) {
            stringArray = this.ArrayListToStringArray(arrayList);
            stringArray2 = this.ArrayListToStringArray(arrayList2);
        }
        if (EndUserError.isError(n3 = this.library.GetCertificatesFromLDAPByEDRPOUCode(string, n, n2, stringArray, stringArray2, byArrayArray))) {
            this.RaiseError(n3);
        }
        return byArrayArray[0];
    }

    public EndUserTimeInfo GetSignTimeInfo(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.GetSignTimeInfo(n, string, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserTimeInfo(blArray[0], blArray2[0], sArray);
    }

    public EndUserTimeInfo GetFileSignTimeInfo(int n, String string) throws Exception {
        this.CheckLibraryLoad();
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray = new short[6];
        int n2 = this.library.GetFileSignTimeInfo(n, string, blArray, blArray2, sArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return new EndUserTimeInfo(blArray[0], blArray2[0], sArray);
    }

    public String VerifyHashOnTime(String string, int n, String string2, String string3, boolean bl) throws Exception {
        return this.VerifyHashOnTimeEx(string, n, string2, string3, string3 != null, false, bl);
    }

    public String VerifyHashOnTimeEx(String string, int n, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        String[] stringArray = new String[]{null};
        if (string3 != null) {
            sArray = this.DateTimeFromString(string3);
        }
        if (EndUserError.isError(n2 = this.library.VerifyHashOnTime(string, n, string2, sArray, bl, bl2, bl3, stringArray))) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyHashOnTime(String string, int n, String string2, String string3) throws Exception {
        return this.VerifyHashOnTimeEx(string, n, string2, string3, string3 != null, false);
    }

    public EndUserSignInfo VerifyHashOnTimeEx(String string, int n, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetSignerInfo(n, string2);
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray2 = new short[6];
        if (string3 != null) {
            sArray = this.DateTimeFromString(string3);
        }
        if (EndUserError.isError(n2 = this.library.VerifyHashOnTimeEx(string, n, string2, sArray, bl, bl2, blArray, blArray2, sArray2))) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray2), null);
    }

    public String VerifyDataOnTime(byte[] byArray, int n, String string, String string2, boolean bl) throws Exception {
        return this.VerifyDataOnTimeEx(byArray, n, string, string2, string2 != null, false, bl);
    }

    public String VerifyDataOnTime(String string, int n, String string2, String string3, boolean bl) throws Exception {
        return this.VerifyDataOnTime(this.GetBytesFromString(string), n, string2, string3, bl);
    }

    public String VerifyDataOnTimeEx(byte[] byArray, int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        String[] stringArray = new String[]{null};
        if (string2 != null) {
            sArray = this.DateTimeFromString(string2);
        }
        if (EndUserError.isError(n2 = this.library.VerifyDataOnTime(byArray, n, string, sArray, bl, bl2, bl3, stringArray))) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String VerifyDataOnTimeEx(String string, int n, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws Exception {
        return this.VerifyDataOnTimeEx(this.GetBytesFromString(string), n, string2, string3, bl, bl2, bl3);
    }

    public EndUserSignInfo VerifyDataOnTime(byte[] byArray, int n, String string, String string2) throws Exception {
        return this.VerifyDataOnTimeEx(byArray, n, string, string2, string2 != null, false);
    }

    public EndUserSignInfo VerifyDataOnTime(String string, int n, String string2, String string3) throws Exception {
        return this.VerifyDataOnTime(this.GetBytesFromString(string), n, string2, string3);
    }

    public EndUserSignInfo VerifyDataOnTimeEx(byte[] byArray, int n, String string, String string2, boolean bl, boolean bl2) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetSignerInfo(n, string);
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray2 = new short[6];
        if (string2 != null) {
            sArray = this.DateTimeFromString(string2);
        }
        if (EndUserError.isError(n2 = this.library.VerifyDataOnTimeEx(byArray, n, string, sArray, bl, bl2, blArray, blArray2, sArray2))) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray2), null);
    }

    public EndUserSignInfo VerifyDataOnTimeEx(String string, int n, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        return this.VerifyDataOnTimeEx(this.GetBytesFromString(string), n, string2, string3, bl, bl2);
    }

    public byte[] VerifyDataInternalOnTime(String string, int n, String string2, boolean bl) throws Exception {
        return this.VerifyDataInternalOnTimeEx(string, n, string2, string2 != null, false, bl);
    }

    public String VerifyDataInternalOnTimeString(String string, int n, String string2, boolean bl) throws Exception {
        return new String(this.VerifyDataInternalOnTime(string, n, string2, bl), this.charset);
    }

    public byte[] VerifyDataInternalOnTimeEx(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        if (string2 != null) {
            sArray = this.DateTimeFromString(string2);
        }
        if (EndUserError.isError(n2 = this.library.VerifyDataInternalOnTime(string, n, sArray, bl, bl2, bl3, byArrayArray, stringArray))) {
            this.RaiseError(n2);
        }
        return byArrayArray[0];
    }

    public String VerifyDataInternalOnTimeStringEx(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        return new String(this.VerifyDataInternalOnTimeEx(string, n, string2, bl, bl2, bl3), this.charset);
    }

    public EndUserSignInfo VerifyDataInternalOnTime(String string, int n, String string2) throws Exception {
        return this.VerifyDataInternalOnTimeEx(string, n, string2, string2 != null, false);
    }

    public EndUserSignInfo VerifyDataInternalOnTimeEx(String string, int n, String string2, boolean bl, boolean bl2) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        byte[][] byArrayArray = new byte[][]{null};
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray2 = new short[6];
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetSignerInfo(n, string);
        if (string2 != null) {
            sArray = this.DateTimeFromString(string2);
        }
        if (EndUserError.isError(n2 = this.library.VerifyDataInternalOnTimeEx(string, n, sArray, bl, bl2, byArrayArray, blArray, blArray2, sArray2))) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray2), byArrayArray[0]);
    }

    public void VerifyDataOnTimeBegin(int n, String string, String string2) throws Exception {
        this.VerifyDataOnTimeBeginEx(n, string, string2, string2 != null, false);
    }

    public void VerifyDataOnTimeBeginEx(int n, String string, String string2, boolean bl, boolean bl2) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        if (string2 != null) {
            sArray = this.DateTimeFromString(string2);
        }
        if (EndUserError.isError(n2 = this.library.VerifyDataOnTimeBegin(n, string, sArray, bl, bl2))) {
            this.RaiseError(n2);
        }
    }

    public String VerifyFileWithExternalSignOnTime(int n, String string, String string2, String string3, boolean bl) throws Exception {
        return this.VerifyFileWithExternalSignOnTimeEx(n, string, string2, string3, string3 != null, false, bl);
    }

    public String VerifyFileWithExternalSignOnTimeEx(int n, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        String[] stringArray = new String[]{null};
        if (string3 != null) {
            sArray = this.DateTimeFromString(string3);
        }
        if (EndUserError.isError(n2 = this.library.VerifyFileOnTime(n, string2, string, sArray, bl, bl2, bl3, stringArray))) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyFileWithExternalSignOnTime(int n, String string, String string2, String string3) throws Exception {
        return this.VerifyFileWithExternalSignOnTimeEx(n, string, string2, string3, string3 != null, false);
    }

    public EndUserSignInfo VerifyFileWithExternalSignOnTimeEx(int n, String string, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray2 = new short[6];
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetFileSignerInfo(n, string2);
        if (string3 != null) {
            sArray = this.DateTimeFromString(string3);
        }
        if (EndUserError.isError(n2 = this.library.VerifyFileOnTimeEx(n, string2, string, sArray, bl, bl2, blArray, blArray2, sArray2))) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray2), null);
    }

    public String VerifyFileWithInternalSignOnTime(int n, String string, String string2, String string3, boolean bl) throws Exception {
        return this.VerifyFileWithInternalSignOnTimeEx(n, string, string2, string3, string3 != null, false, bl);
    }

    public String VerifyFileWithInternalSignOnTimeEx(int n, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        String[] stringArray = new String[]{null};
        if (string3 != null) {
            sArray = this.DateTimeFromString(string3);
        }
        if (EndUserError.isError(n2 = this.library.VerifyFileOnTime(n, string, string2, sArray, bl, bl2, bl3, stringArray))) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public EndUserSignInfo VerifyFileWithInternalSignOnTime(int n, String string, String string2, String string3) throws Exception {
        return this.VerifyFileWithInternalSignOnTimeEx(n, string, string2, string3, string3 != null, false);
    }

    public EndUserSignInfo VerifyFileWithInternalSignOnTimeEx(int n, String string, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        int n2;
        this.CheckLibraryLoad();
        short[] sArray = null;
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        short[] sArray2 = new short[6];
        EndUserCertificateInfoEx endUserCertificateInfoEx = this.GetFileSignerInfo(n, string);
        if (string3 != null) {
            sArray = this.DateTimeFromString(string3);
        }
        if (EndUserError.isError(n2 = this.library.VerifyFileOnTimeEx(n, string, string2, sArray, bl, bl2, blArray, blArray2, sArray2))) {
            this.RaiseError(n2);
        }
        return new EndUserSignInfo(new EndUserOwnerInfo(endUserCertificateInfoEx.GetIssuer(), endUserCertificateInfoEx.GetIssuerCN(), endUserCertificateInfoEx.GetSerial(), endUserCertificateInfoEx.GetSubject(), endUserCertificateInfoEx.GetSubjCN(), endUserCertificateInfoEx.GetSubjOrg(), endUserCertificateInfoEx.GetSubjOrgUnit(), endUserCertificateInfoEx.GetSubjTitle(), endUserCertificateInfoEx.GetSubjState(), endUserCertificateInfoEx.GetSubjLocality(), endUserCertificateInfoEx.GetSubjFullName(), endUserCertificateInfoEx.GetSubjAddress(), endUserCertificateInfoEx.GetSubjPhone(), endUserCertificateInfoEx.GetSubjEMail(), endUserCertificateInfoEx.GetSubjDNS(), endUserCertificateInfoEx.GetSubjEDRPOUCode(), endUserCertificateInfoEx.GetSubjDRFOCode()), new EndUserTimeInfo(blArray[0], blArray2[0], sArray2), null);
    }

    public String RawEnvelop(byte[] byArray, byte[] byArray2) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.RawEnvelop(byArray, byArray2, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public byte[] RawDevelop(String string, boolean bl) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        String[] stringArray = new String[]{null};
        int n = this.library.RawDevelop(string, byArrayArray, bl, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public String RawEnvelop(byte[] byArray, String string) throws Exception {
        return this.RawEnvelop(byArray, this.GetBytesFromString(string));
    }

    public String EnvelopRSA(int n, String string, String string2, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnvelopRSA(n, string, string2, bl, byArray, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String EnvelopRSA(int n, String string, String string2, boolean bl, String string3) throws Exception {
        return this.EnvelopRSA(n, string, string2, bl, this.GetBytesFromString(string3));
    }

    public void EnvelopFileRSA(int n, String string, String string2, boolean bl, String string3, String string4) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.EnvelopFileRSA(n, string, string2, bl, string3, string4);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public String EnvelopRSAEx(int n, ArrayList arrayList, ArrayList arrayList2, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnvelopRSAEx(n, this.ArrayListToStringArray(arrayList), this.ArrayListToStringArray(arrayList2), bl, byArray, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String EnvelopRSAEx(int n, ArrayList arrayList, ArrayList arrayList2, boolean bl, String string) throws Exception {
        return this.EnvelopRSAEx(n, arrayList, arrayList2, bl, this.GetBytesFromString(string));
    }

    public void EnvelopFileRSAEx(int n, ArrayList arrayList, ArrayList arrayList2, boolean bl, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.EnvelopFileRSAEx(n, this.ArrayListToStringArray(arrayList), this.ArrayListToStringArray(arrayList2), bl, string, string2);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public String EnvelopToRecipientsRSA(int n, ArrayList arrayList, boolean bl, byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n2 = this.library.EnvelopToRecipientsRSA(n, this.ArrayListToByteArray(arrayList), bl, byArray, stringArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return stringArray[0];
    }

    public String EnvelopToRecipientsRSA(int n, ArrayList arrayList, boolean bl, String string) throws Exception {
        return this.EnvelopToRecipientsRSA(n, arrayList, bl, this.GetBytesFromString(string));
    }

    public void EnvelopFileToRecipientsRSA(int n, ArrayList arrayList, boolean bl, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.EnvelopFileToRecipientsRSA(n, this.ArrayListToByteArray(arrayList), bl, string, string2);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public byte[] ChangeSoftwarePrivateKeyPassword(byte[] byArray, String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.ChangeSoftwarePrivateKeyPassword(byArray, string, string2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public EndUserKeyMedia CreateKeyMedia() throws Exception {
        return new EndUserKeyMedia(0, 0, "");
    }

    public EndUserDeviceContext CreateDeviceContext() throws Exception {
        return new EndUserDeviceContext(0L);
    }

    public String DevCtxEnumVirtual(EndUserDeviceContext endUserDeviceContext) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        String[] stringArray = new String[]{null};
        lArray[0] = endUserDeviceContext.GetHandle();
        int n = this.library.DevCtxEnumVirtual(lArray, stringArray);
        if (EndUserError.isError(n)) {
            if (n == 7) {
                return null;
            }
            this.RaiseError(n);
        }
        endUserDeviceContext.SetHandle(lArray[0]);
        return stringArray[0];
    }

    public String DevCtxEnum(EndUserDeviceContext endUserDeviceContext) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.DevCtxEnum(endUserDeviceContext.GetHandle(), stringArray);
        if (EndUserError.isError(n)) {
            if (n == 7) {
                return null;
            }
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public EndUserDeviceContext DevCtxOpen(String string, String string2, String string3) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        int n = this.library.DevCtxOpen(string, string2, string3, lArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserDeviceContext(lArray[0]);
    }

    public void DevCtxClose(EndUserDeviceContext endUserDeviceContext) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.DevCtxClose(endUserDeviceContext.GetHandle());
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public byte[] DevCtxGetData(EndUserDeviceContext endUserDeviceContext, byte by) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.DevCtxGetData(endUserDeviceContext.GetHandle(), by, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public void DevCtxChangePassword(EndUserDeviceContext endUserDeviceContext, String string) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.DevCtxChangePassword(endUserDeviceContext.GetHandle(), string);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public String ProtectDataByPassword(byte[] byArray, String string) throws Exception {
        this.CheckLibraryLoad();
        String[] stringArray = new String[]{null};
        int n = this.library.ProtectDataByPassword(byArray, string, stringArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return stringArray[0];
    }

    public String ProtectDataByPassword(String string, String string2) throws Exception {
        return this.ProtectDataByPassword(this.GetBytesFromString(string), string2);
    }

    public byte[] UnprotectDataByPassword(String string, String string2) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n = this.library.UnprotectDataByPassword(string, string2, byArrayArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return byArrayArray[0];
    }

    public byte[] GeneratePRNGSequence(int n) throws Exception {
        this.CheckLibraryLoad();
        byte[][] byArrayArray = new byte[][]{null};
        int n2 = this.library.GeneratePRNGSequence(n, byArrayArray);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
        return byArrayArray[0];
    }

    public void SetSettingsFilePath(String string) throws Exception {
        this.CheckLibraryLoad();
        int n = this.library.SetSettingsFilePath(string);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
    }

    public void SetSettingsFilePathEx(String string, int n, String string2) throws Exception {
        this.CheckLibraryLoad();
        int n2 = this.library.SetSettingsFilePathEx(string, n, string2);
        if (EndUserError.isError(n2)) {
            this.RaiseError(n2);
        }
    }

    public EndUserSession ClientDynamicKeySessionLoad(byte[] byArray) throws Exception {
        this.CheckLibraryLoad();
        long[] lArray = new long[]{0L};
        int n = this.library.ClientDynamicKeySessionLoad(byArray, lArray);
        if (EndUserError.isError(n)) {
            this.RaiseError(n);
        }
        return new EndUserSession(lArray[0], null);
    }

    public byte[] Concatenate(byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public byte[] Copy(byte[] byArray, int n, int n2) throws Exception {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public EndUser() {
        try {
            this.library = new EndUserLibrary();
        }
        catch (Exception exception) {
            this.library = null;
        }
    }
}

