/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.devtools.common.options.BoolOrEnumConverter;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.Converters;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.TriState;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class OptionsParserImpl {
    static final Map<Class<?>, Converter<?>> DEFAULT_CONVERTERS = Maps.newHashMap();
    private final OptionsData optionsData;
    private final Map<Field, ParsedOptionEntry> parsedValues = Maps.newHashMap();
    private final List<OptionsParser.UnparsedOptionValueDescription> unparsedValues = Lists.newArrayList();
    private final Multimap<Field, OptionsParser.UnparsedOptionValueDescription> canonicalizeValues = LinkedHashMultimap.create();
    private final List<String> warnings = Lists.newArrayList();
    private boolean allowSingleDashLongOptions = false;

    OptionsParserImpl(OptionsData optionsData) {
        this.optionsData = optionsData;
    }

    void setAllowSingleDashLongOptions(boolean allowSingleDashLongOptions) {
        this.allowSingleDashLongOptions = allowSingleDashLongOptions;
    }

    static Map<String, Object> optionsAsMap(OptionsBase optionsInstance) {
        HashMap<String, Object> map = Maps.newHashMap();
        for (Field field : OptionsParser.getAllAnnotatedFields(optionsInstance.getClass())) {
            try {
                String name = field.getAnnotation(Option.class).name();
                Object value = field.get(optionsInstance);
                map.put(name, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return map;
    }

    List<Field> getAnnotatedFieldsFor(Class<? extends OptionsBase> clazz) {
        return this.optionsData.getFieldsForClass(clazz);
    }

    List<OptionsParser.UnparsedOptionValueDescription> asListOfUnparsedOptions() {
        ArrayList<OptionsParser.UnparsedOptionValueDescription> result = Lists.newArrayList(this.unparsedValues);
        Collections.sort(result, new Comparator<OptionsParser.UnparsedOptionValueDescription>(){

            @Override
            public int compare(OptionsParser.UnparsedOptionValueDescription o1, OptionsParser.UnparsedOptionValueDescription o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
        return result;
    }

    List<OptionsParser.UnparsedOptionValueDescription> asListOfExplicitOptions() {
        ArrayList<OptionsParser.UnparsedOptionValueDescription> result = Lists.newArrayList(Iterables.filter(this.unparsedValues, new Predicate<OptionsParser.UnparsedOptionValueDescription>(){

            @Override
            public boolean apply(OptionsParser.UnparsedOptionValueDescription input) {
                return input.isExplicit();
            }
        }));
        Collections.sort(result, new Comparator<OptionsParser.UnparsedOptionValueDescription>(){

            @Override
            public int compare(OptionsParser.UnparsedOptionValueDescription o1, OptionsParser.UnparsedOptionValueDescription o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
        return result;
    }

    List<String> asCanonicalizedList() {
        ArrayList<OptionsParser.UnparsedOptionValueDescription> processed = Lists.newArrayList(this.canonicalizeValues.values());
        Collections.sort(processed, new Comparator<OptionsParser.UnparsedOptionValueDescription>(){

            @Override
            public int compare(OptionsParser.UnparsedOptionValueDescription o1, OptionsParser.UnparsedOptionValueDescription o2) {
                if (o1.isImplicitRequirement()) {
                    return o2.isImplicitRequirement() ? 0 : 1;
                }
                if (o2.isImplicitRequirement()) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<String> result = Lists.newArrayList();
        for (OptionsParser.UnparsedOptionValueDescription value : processed) {
            if (value.isExpansion()) continue;
            result.add("--" + value.getName() + "=" + value.getUnparsedValue());
        }
        return result;
    }

    List<OptionsParser.OptionValueDescription> asListOfEffectiveOptions() {
        ArrayList<OptionsParser.OptionValueDescription> result = Lists.newArrayList();
        for (Map.Entry<String, Field> mapEntry : this.optionsData.getAllNamedFields()) {
            String fieldName = mapEntry.getKey();
            Field field = mapEntry.getValue();
            ParsedOptionEntry entry = this.parsedValues.get(field);
            if (entry == null) {
                Object value = this.optionsData.getDefaultValue(field);
                result.add(new OptionsParser.OptionValueDescription(fieldName, value, OptionPriority.DEFAULT, null, null, null));
                continue;
            }
            result.add(entry.asOptionValueDescription(fieldName));
        }
        return result;
    }

    Collection<Class<? extends OptionsBase>> getOptionsClasses() {
        return this.optionsData.getOptionsClasses();
    }

    private void maybeAddDeprecationWarning(Field field) {
        Option option = field.getAnnotation(Option.class);
        String warning = option.deprecationWarning();
        if (!warning.isEmpty() || field.getAnnotation(Deprecated.class) != null) {
            this.addDeprecationWarning(option.name(), warning);
        }
    }

    private void addDeprecationWarning(String optionName, String warning) {
        this.warnings.add("Option '" + optionName + "' is deprecated" + (warning.isEmpty() ? "" : ": " + warning));
    }

    private void setValue(Field field, String name, Object value, OptionPriority priority, String source, String implicitDependant, String expandedFrom) {
        ParsedOptionEntry entry = this.parsedValues.get(field);
        if (entry != null) {
            if (priority.compareTo(entry.priority) >= 0) {
                if (implicitDependant != null && entry.implicitDependant != null) {
                    if (!implicitDependant.equals(entry.implicitDependant)) {
                        this.warnings.add("Option '" + name + "' is implicitly defined by both option '" + entry.implicitDependant + "' and option '" + implicitDependant + "'");
                    }
                } else if (implicitDependant != null && priority.equals((Object)entry.priority)) {
                    this.warnings.add("Option '" + name + "' is implicitly defined by option '" + implicitDependant + "'; the implicitly set value overrides the previous one");
                } else if (entry.implicitDependant != null) {
                    this.warnings.add("A new value for option '" + name + "' overrides a previous implicit setting of that option by option '" + entry.implicitDependant + "'");
                } else if (priority == entry.priority && entry.expandedFrom == null && expandedFrom != null) {
                    this.warnings.add("The option '" + expandedFrom + "' was expanded and now overrides a previous explicitly specified option '" + name + "'");
                }
                this.parsedValues.put(field, new ParsedOptionEntry(value, priority, source, implicitDependant, expandedFrom, false));
            }
        } else {
            this.parsedValues.put(field, new ParsedOptionEntry(value, priority, source, implicitDependant, expandedFrom, false));
            this.maybeAddDeprecationWarning(field);
        }
    }

    private void addListValue(Field field, Object value, OptionPriority priority, String source, String implicitDependant, String expandedFrom) {
        ParsedOptionEntry entry = this.parsedValues.get(field);
        if (entry == null) {
            entry = new ParsedOptionEntry(ArrayListMultimap.create(), priority, source, implicitDependant, expandedFrom, true);
            this.parsedValues.put(field, entry);
            this.maybeAddDeprecationWarning(field);
        }
        entry.addValue(priority, value);
    }

    void clearValue(String optionName, Map<String, OptionsParser.OptionValueDescription> clearedValues) throws OptionsParsingException {
        Field field = this.optionsData.getFieldFromName(optionName);
        if (field == null) {
            throw new IllegalArgumentException("No such option '" + optionName + "'");
        }
        Option option = field.getAnnotation(Option.class);
        this.clearValue(field, option, clearedValues);
    }

    private void clearValue(Field field, Option option, Map<String, OptionsParser.OptionValueDescription> clearedValues) throws OptionsParsingException {
        ParsedOptionEntry removed = this.parsedValues.remove(field);
        if (removed != null) {
            clearedValues.put(option.name(), removed.asOptionValueDescription(option.name()));
        }
        this.canonicalizeValues.removeAll(field);
        for (String[] args : new String[][]{option.implicitRequirements(), option.expansion()}) {
            UnmodifiableIterator<String> argsIterator = Iterators.forArray(args);
            while (argsIterator.hasNext()) {
                String arg = (String)argsIterator.next();
                ParseOptionResult parseOptionResult = this.parseOption(arg, argsIterator);
                this.clearValue(parseOptionResult.field, parseOptionResult.option, clearedValues);
            }
        }
    }

    OptionsParser.OptionValueDescription getOptionValueDescription(String name) {
        Field field = this.optionsData.getFieldFromName(name);
        if (field == null) {
            throw new IllegalArgumentException("No such option '" + name + "'");
        }
        ParsedOptionEntry entry = this.parsedValues.get(field);
        if (entry == null) {
            return null;
        }
        return entry.asOptionValueDescription(name);
    }

    OptionsParser.OptionDescription getOptionDescription(String name) {
        Field field = this.optionsData.getFieldFromName(name);
        if (field == null) {
            return null;
        }
        Option optionAnnotation = field.getAnnotation(Option.class);
        return new OptionsParser.OptionDescription(name, this.optionsData.getDefaultValue(field), this.optionsData.getConverter(field), optionAnnotation.allowMultiple());
    }

    boolean containsExplicitOption(String name) {
        Field field = this.optionsData.getFieldFromName(name);
        if (field == null) {
            throw new IllegalArgumentException("No such option '" + name + "'");
        }
        return this.parsedValues.get(field) != null;
    }

    List<String> parse(OptionPriority priority, Function<? super String, String> sourceFunction, List<String> args) throws OptionsParsingException {
        return this.parse(priority, sourceFunction, null, null, args);
    }

    private List<String> parse(OptionPriority priority, Function<? super String, String> sourceFunction, String implicitDependent, String expandedFrom, List<String> args) throws OptionsParsingException {
        ArrayList<String> unparsedArgs = Lists.newArrayList();
        LinkedHashMap<String, List<String>> implicitRequirements = Maps.newLinkedHashMap();
        Iterator<String> argsIterator = args.iterator();
        while (argsIterator.hasNext()) {
            String arg = argsIterator.next();
            if (!arg.startsWith("-")) {
                unparsedArgs.add(arg);
                continue;
            }
            if (arg.equals("--")) {
                Iterators.addAll(unparsedArgs, argsIterator);
                break;
            }
            ParseOptionResult optionParseResult = this.parseOption(arg, argsIterator);
            Field field = optionParseResult.field;
            Option option = optionParseResult.option;
            String value = optionParseResult.value;
            String originalName = option.name();
            if (option.wrapperOption()) {
                if (value.startsWith("-")) {
                    List<String> unparsed = this.parse(priority, Functions.constant("Unwrapped from wrapper option --" + originalName), null, null, ImmutableList.of(value));
                    if (unparsed.isEmpty()) continue;
                    throw new OptionsParsingException("Unparsed options remain after unwrapping " + arg + ": " + Joiner.on(' ').join(unparsed));
                }
                throw new OptionsParsingException("Invalid --" + originalName + " value format. You may have meant --" + originalName + "=--" + value);
            }
            if (implicitDependent == null) {
                OptionsParser.UnparsedOptionValueDescription unparsedOptionValueDescription = new OptionsParser.UnparsedOptionValueDescription(originalName, field, value, priority, sourceFunction.apply(originalName), expandedFrom == null);
                this.unparsedValues.add(unparsedOptionValueDescription);
                if (option.allowMultiple()) {
                    this.canonicalizeValues.put(field, unparsedOptionValueDescription);
                } else {
                    this.canonicalizeValues.replaceValues(field, ImmutableList.of(unparsedOptionValueDescription));
                }
            }
            if (option.expansion().length > 0) {
                Function<Object, String> expansionSourceFunction = Functions.constant("expanded from option --" + originalName + " from " + sourceFunction.apply(originalName));
                this.maybeAddDeprecationWarning(field);
                List<String> unparsed = this.parse(priority, expansionSourceFunction, null, originalName, ImmutableList.copyOf(option.expansion()));
                if (!unparsed.isEmpty()) {
                    throw new AssertionError((Object)("Unparsed options remain after parsing expansion of " + arg + ": " + Joiner.on(' ').join(unparsed)));
                }
            } else {
                Object convertedValue;
                Converter<?> converter = this.optionsData.getConverter(field);
                try {
                    convertedValue = converter.convert(value);
                }
                catch (OptionsParsingException e) {
                    throw new OptionsParsingException("While parsing option " + arg + ": " + e.getMessage(), e);
                }
                if (!option.allowMultiple()) {
                    this.setValue(field, originalName, convertedValue, priority, sourceFunction.apply(originalName), implicitDependent, expandedFrom);
                } else {
                    this.addListValue(field, convertedValue, priority, sourceFunction.apply(originalName), implicitDependent, expandedFrom);
                }
            }
            if (option.implicitRequirements().length <= 0) continue;
            implicitRequirements.put(option.name(), Arrays.asList(option.implicitRequirements()));
        }
        if (!implicitRequirements.isEmpty()) {
            for (Map.Entry entry : implicitRequirements.entrySet()) {
                Function<Object, String> requirementSourceFunction = Functions.constant("implicit requirement of option --" + (String)entry.getKey() + " from " + sourceFunction.apply((String)entry.getKey()));
                List<String> unparsed = this.parse(priority, requirementSourceFunction, (String)entry.getKey(), null, (List)entry.getValue());
                if (!unparsed.isEmpty()) {
                    throw new AssertionError((Object)("Unparsed options remain after parsing implicit options: " + Joiner.on(' ').join(unparsed)));
                }
            }
        }
        return unparsedArgs;
    }

    private ParseOptionResult parseOption(String arg, Iterator<String> nextArgs) throws OptionsParsingException {
        Field field;
        String value = null;
        boolean booleanValue = true;
        if (arg.length() == 2) {
            field = this.optionsData.getFieldForAbbrev(arg.charAt(1));
            booleanValue = true;
        } else if (arg.length() == 3 && arg.charAt(2) == '-') {
            field = this.optionsData.getFieldForAbbrev(arg.charAt(1));
            booleanValue = false;
        } else if (this.allowSingleDashLongOptions || arg.startsWith("--")) {
            String name;
            int equalsAt = arg.indexOf(61);
            int nameStartsAt = arg.startsWith("--") ? 2 : 1;
            String string = name = equalsAt == -1 ? arg.substring(nameStartsAt) : arg.substring(nameStartsAt, equalsAt);
            if (name.trim().isEmpty()) {
                throw new OptionsParsingException("Invalid options syntax: " + arg, arg);
            }
            value = equalsAt == -1 ? null : arg.substring(equalsAt + 1);
            field = this.optionsData.getFieldFromName(name);
            if (field == null && name.startsWith("no")) {
                name = name.substring(name.startsWith("no_") ? 3 : 2);
                field = this.optionsData.getFieldFromName(name);
                booleanValue = false;
                if (field != null) {
                    if (!OptionsParserImpl.isBooleanField(field)) {
                        throw new OptionsParsingException("Illegal use of 'no' prefix on non-boolean option: " + arg, arg);
                    }
                    if (value != null) {
                        throw new OptionsParsingException("Unexpected value after boolean option: " + arg, arg);
                    }
                    value = "0";
                }
            }
        } else {
            throw new OptionsParsingException("Invalid options syntax: " + arg, arg);
        }
        if (field == null) {
            throw new OptionsParsingException("Unrecognized option: " + arg, arg);
        }
        Option option = field.getAnnotation(Option.class);
        if (value == null) {
            if (OptionsParserImpl.isBooleanField(field)) {
                value = booleanValue ? "1" : "0";
            } else if (!field.getType().equals(Void.class) || option.wrapperOption()) {
                if (nextArgs.hasNext()) {
                    value = nextArgs.next();
                } else {
                    throw new OptionsParsingException("Expected value after " + arg);
                }
            }
        }
        return new ParseOptionResult(field, option, value);
    }

    <O extends OptionsBase> O getParsedOptions(Class<O> optionsClass) {
        OptionsBase optionsInstance;
        try {
            Constructor<O> constructor = this.optionsData.getConstructor(optionsClass);
            if (constructor == null) {
                return null;
            }
            optionsInstance = (OptionsBase)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (Field field : this.optionsData.getFieldsForClass(optionsClass)) {
            ParsedOptionEntry entry = this.parsedValues.get(field);
            Object value = entry == null ? this.optionsData.getDefaultValue(field) : entry.getValue();
            try {
                field.set(optionsInstance, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return (O)optionsInstance;
    }

    List<String> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    static String getDefaultOptionString(Field optionField) {
        Option annotation = optionField.getAnnotation(Option.class);
        return annotation.defaultValue();
    }

    static boolean isBooleanField(Field field) {
        return field.getType().equals(Boolean.TYPE) || field.getType().equals(TriState.class) || OptionsParserImpl.findConverter(field) instanceof BoolOrEnumConverter;
    }

    static boolean isVoidField(Field field) {
        return field.getType().equals(Void.class);
    }

    static boolean isSpecialNullDefault(String defaultValueString, Field optionField) {
        return defaultValueString.equals("null") && !optionField.getType().isPrimitive();
    }

    static Converter<?> findConverter(Field optionField) {
        Option annotation = optionField.getAnnotation(Option.class);
        if (annotation.converter() == Converter.class) {
            Type type = annotation.allowMultiple() ? ((ParameterizedType)optionField.getGenericType()).getActualTypeArguments()[0] : optionField.getType();
            Converter<?> converter = DEFAULT_CONVERTERS.get(type);
            if (converter == null) {
                throw new AssertionError((Object)("No converter found for " + type + "; possible fix: add converter=... to @Option annotation for " + optionField.getName()));
            }
            return converter;
        }
        try {
            Class<? extends Converter> converter = annotation.converter();
            Constructor<? extends Converter> constructor = converter.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        DEFAULT_CONVERTERS.put(String.class, new Converter<String>(){

            @Override
            public String convert(String input) {
                return input;
            }

            @Override
            public String getTypeDescription() {
                return "a string";
            }
        });
        DEFAULT_CONVERTERS.put(Integer.TYPE, new Converter<Integer>(){

            @Override
            public Integer convert(String input) throws OptionsParsingException {
                try {
                    return Integer.decode(input);
                }
                catch (NumberFormatException e) {
                    throw new OptionsParsingException("'" + input + "' is not an int");
                }
            }

            @Override
            public String getTypeDescription() {
                return "an integer";
            }
        });
        DEFAULT_CONVERTERS.put(Double.TYPE, new Converter<Double>(){

            @Override
            public Double convert(String input) throws OptionsParsingException {
                try {
                    return Double.parseDouble(input);
                }
                catch (NumberFormatException e) {
                    throw new OptionsParsingException("'" + input + "' is not a double");
                }
            }

            @Override
            public String getTypeDescription() {
                return "a double";
            }
        });
        DEFAULT_CONVERTERS.put(Boolean.TYPE, new Converters.BooleanConverter());
        DEFAULT_CONVERTERS.put(TriState.class, new Converter<TriState>(){

            @Override
            public TriState convert(String input) throws OptionsParsingException {
                if (input == null) {
                    return TriState.AUTO;
                }
                if ((input = input.toLowerCase()).equals("auto")) {
                    return TriState.AUTO;
                }
                if (input.equals("true") || input.equals("1") || input.equals("yes") || input.equals("t") || input.equals("y")) {
                    return TriState.YES;
                }
                if (input.equals("false") || input.equals("0") || input.equals("no") || input.equals("f") || input.equals("n")) {
                    return TriState.NO;
                }
                throw new OptionsParsingException("'" + input + "' is not a boolean");
            }

            @Override
            public String getTypeDescription() {
                return "a tri-state (auto, yes, no)";
            }
        });
        DEFAULT_CONVERTERS.put(Void.class, new Converter<Void>(){

            @Override
            public Void convert(String input) throws OptionsParsingException {
                if (input == null) {
                    return null;
                }
                throw new OptionsParsingException("'" + input + "' unexpected");
            }

            @Override
            public String getTypeDescription() {
                return "";
            }
        });
        DEFAULT_CONVERTERS.put(Long.TYPE, new Converter<Long>(){

            @Override
            public Long convert(String input) throws OptionsParsingException {
                try {
                    return Long.decode(input);
                }
                catch (NumberFormatException e) {
                    throw new OptionsParsingException("'" + input + "' is not a long");
                }
            }

            @Override
            public String getTypeDescription() {
                return "a long integer";
            }
        });
    }

    private static final class ParseOptionResult {
        final Field field;
        final Option option;
        final String value;

        ParseOptionResult(Field field, Option option, String value) {
            this.field = field;
            this.option = option;
            this.value = value;
        }
    }

    private static final class ParsedOptionEntry {
        private final Object value;
        private final OptionPriority priority;
        private final String source;
        private final String implicitDependant;
        private final String expandedFrom;
        private final boolean allowMultiple;

        ParsedOptionEntry(Object value, OptionPriority priority, String source, String implicitDependant, String expandedFrom, boolean allowMultiple) {
            this.value = value;
            this.priority = priority;
            this.source = source;
            this.implicitDependant = implicitDependant;
            this.expandedFrom = expandedFrom;
            this.allowMultiple = allowMultiple;
        }

        Object getValue() {
            if (this.allowMultiple) {
                ArrayList result = Lists.newArrayList();
                ListMultimap realValue = (ListMultimap)this.value;
                for (OptionPriority priority : OptionPriority.values()) {
                    if (!realValue.containsKey((Object)priority)) continue;
                    result.addAll(realValue.get(priority));
                }
                return result;
            }
            return this.value;
        }

        void addValue(OptionPriority addedPriority, Object addedValue) {
            Preconditions.checkState(this.allowMultiple);
            ListMultimap optionValueList = (ListMultimap)this.value;
            if (addedValue instanceof List) {
                for (Object element : (List)addedValue) {
                    optionValueList.put(addedPriority, element);
                }
            } else {
                optionValueList.put(addedPriority, addedValue);
            }
        }

        OptionsParser.OptionValueDescription asOptionValueDescription(String fieldName) {
            return new OptionsParser.OptionValueDescription(fieldName, this.getValue(), this.priority, this.source, this.implicitDependant, this.expandedFrom);
        }
    }
}

