/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OpaqueOptionsData;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParserImpl;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.OptionsProvider;
import com.google.devtools.common.options.OptionsUsage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionsParser
implements OptionsProvider {
    private static final Map<ImmutableList<Class<? extends OptionsBase>>, OptionsData> optionsData = Maps.newHashMap();
    private final OptionsParserImpl impl;
    private final List<String> residue = new ArrayList<String>();
    private boolean allowResidue = true;

    public static OpaqueOptionsData getOptionsData(ImmutableList<Class<? extends OptionsBase>> optionsClasses) {
        return OptionsParser.getOptionsDataInternal(optionsClasses);
    }

    private static synchronized OptionsData getOptionsDataInternal(ImmutableList<Class<? extends OptionsBase>> optionsClasses) {
        OptionsData result = optionsData.get(optionsClasses);
        if (result == null) {
            result = OptionsData.of(optionsClasses);
            optionsData.put(optionsClasses, result);
        }
        return result;
    }

    static Collection<Field> getAllAnnotatedFields(Class<? extends OptionsBase> optionsClass) {
        OptionsData data = OptionsParser.getOptionsDataInternal(ImmutableList.of(optionsClass));
        return data.getFieldsForClass(optionsClass);
    }

    public static OptionsParser newOptionsParser(Class<? extends OptionsBase> class1) {
        return OptionsParser.newOptionsParser(ImmutableList.of(class1));
    }

    public static OptionsParser newOptionsParser(Class<? extends OptionsBase> class1, Class<? extends OptionsBase> class2) {
        return OptionsParser.newOptionsParser(ImmutableList.of(class1, class2));
    }

    public static OptionsParser newOptionsParser(Iterable<? extends Class<? extends OptionsBase>> optionsClasses) {
        return OptionsParser.newOptionsParser(OptionsParser.getOptionsDataInternal(ImmutableList.copyOf(optionsClasses)));
    }

    public static OptionsParser newOptionsParser(OpaqueOptionsData optionsData) {
        return new OptionsParser((OptionsData)optionsData);
    }

    OptionsParser(Collection<Class<? extends OptionsBase>> optionsClasses) {
        this(OptionsData.of(optionsClasses));
    }

    OptionsParser(OptionsData optionsData) {
        this.impl = new OptionsParserImpl(optionsData);
    }

    public void setAllowResidue(boolean allowResidue) {
        this.allowResidue = allowResidue;
    }

    public void setAllowSingleDashLongOptions(boolean allowSingleDashLongOptions) {
        this.impl.setAllowSingleDashLongOptions(allowSingleDashLongOptions);
    }

    public void parseAndExitUponError(String[] args) {
        this.parseAndExitUponError(OptionPriority.COMMAND_LINE, "unknown", args);
    }

    public void parseAndExitUponError(OptionPriority priority, String source, String[] args) {
        for (String arg : args) {
            if (!arg.equals("--help")) continue;
            System.out.println(this.describeOptions(Collections.emptyMap(), HelpVerbosity.LONG));
            System.exit(0);
        }
        try {
            this.parse(priority, source, Arrays.asList(args));
        }
        catch (OptionsParsingException e) {
            System.err.println("Error parsing command line: " + e.getMessage());
            System.err.println("Try --help.");
            System.exit(2);
        }
    }

    public String describeOptions(Map<String, String> categoryDescriptions, HelpVerbosity helpVerbosity) {
        StringBuilder desc = new StringBuilder();
        if (!this.impl.getOptionsClasses().isEmpty()) {
            ArrayList<Field> allFields = Lists.newArrayList();
            for (Class<? extends OptionsBase> optionsClass : this.impl.getOptionsClasses()) {
                allFields.addAll(this.impl.getAnnotatedFieldsFor(optionsClass));
            }
            Collections.sort(allFields, OptionsUsage.BY_CATEGORY);
            String prevCategory = null;
            for (Field optionField : allFields) {
                String category = optionField.getAnnotation(Option.class).category();
                if (!category.equals(prevCategory)) {
                    prevCategory = category;
                    String description = categoryDescriptions.get(category);
                    if (description == null) {
                        description = "Options category '" + category + "'";
                    }
                    if (OptionsParser.documentationLevel(category) == DocumentationLevel.DOCUMENTED) {
                        desc.append("\n").append(description).append(":\n");
                    }
                }
                if (OptionsParser.documentationLevel(prevCategory) != DocumentationLevel.DOCUMENTED) continue;
                OptionsUsage.getUsage(optionField, desc, helpVerbosity);
            }
        }
        return desc.toString().trim();
    }

    public String describeOptionsHtml(Map<String, String> categoryDescriptions, Escaper escaper) {
        StringBuilder desc = new StringBuilder();
        if (!this.impl.getOptionsClasses().isEmpty()) {
            ArrayList<Field> allFields = Lists.newArrayList();
            for (Class<? extends OptionsBase> optionsClass : this.impl.getOptionsClasses()) {
                allFields.addAll(this.impl.getAnnotatedFieldsFor(optionsClass));
            }
            Collections.sort(allFields, OptionsUsage.BY_CATEGORY);
            String prevCategory = null;
            for (Field optionField : allFields) {
                String category = optionField.getAnnotation(Option.class).category();
                DocumentationLevel level = OptionsParser.documentationLevel(category);
                if (!category.equals(prevCategory) && level == DocumentationLevel.DOCUMENTED) {
                    String description = categoryDescriptions.get(category);
                    if (description == null) {
                        description = "Options category '" + category + "'";
                    }
                    if (prevCategory != null) {
                        desc.append("</dl>\n\n");
                    }
                    desc.append(escaper.escape(description)).append(":\n");
                    desc.append("<dl>");
                    prevCategory = category;
                }
                if (level != DocumentationLevel.DOCUMENTED) continue;
                OptionsUsage.getUsageHtml(optionField, desc, escaper);
            }
            desc.append("</dl>\n");
        }
        return desc.toString();
    }

    public String getOptionsCompletion() {
        StringBuilder desc = new StringBuilder();
        ArrayList<Field> allFields = Lists.newArrayList();
        for (Class<? extends OptionsBase> optionsClass : this.impl.getOptionsClasses()) {
            allFields.addAll(this.impl.getAnnotatedFieldsFor(optionsClass));
        }
        Collections.sort(allFields, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                String name1 = f1.getAnnotation(Option.class).name();
                String name2 = f2.getAnnotation(Option.class).name();
                return name1.compareTo(name2);
            }
        });
        for (Field optionField : allFields) {
            String category = optionField.getAnnotation(Option.class).category();
            if (OptionsParser.documentationLevel(category) != DocumentationLevel.DOCUMENTED) continue;
            OptionsUsage.getCompletion(optionField, desc);
        }
        return desc.toString();
    }

    public OptionDescription getOptionDescription(String name) {
        return this.impl.getOptionDescription(name);
    }

    public OptionValueDescription getOptionValueDescription(String name) {
        return this.impl.getOptionValueDescription(name);
    }

    static DocumentationLevel documentationLevel(String category) {
        if ("undocumented".equals(category)) {
            return DocumentationLevel.UNDOCUMENTED;
        }
        if ("hidden".equals(category)) {
            return DocumentationLevel.HIDDEN;
        }
        return DocumentationLevel.DOCUMENTED;
    }

    public void parse(String ... args) throws OptionsParsingException {
        this.parse(OptionPriority.COMMAND_LINE, (String)null, Arrays.asList(args));
    }

    public void parse(List<String> args) throws OptionsParsingException {
        this.parse(OptionPriority.COMMAND_LINE, (String)null, args);
    }

    public void parse(OptionPriority priority, String source, List<String> args) throws OptionsParsingException {
        this.parseWithSourceFunction(priority, Functions.constant(source), args);
    }

    public void parseWithSourceFunction(OptionPriority priority, Function<? super String, String> sourceFunction, List<String> args) throws OptionsParsingException {
        Preconditions.checkNotNull(priority);
        Preconditions.checkArgument(priority != OptionPriority.DEFAULT);
        this.residue.addAll(this.impl.parse(priority, sourceFunction, args));
        if (!this.allowResidue && !this.residue.isEmpty()) {
            String errorMsg = "Unrecognized arguments: " + Joiner.on(' ').join(this.residue);
            throw new OptionsParsingException(errorMsg);
        }
    }

    public Map<String, OptionValueDescription> clearValue(String optionName) throws OptionsParsingException {
        HashMap<String, OptionValueDescription> clearedValues = Maps.newHashMap();
        this.impl.clearValue(optionName, clearedValues);
        return clearedValues;
    }

    @Override
    public List<String> getResidue() {
        return ImmutableList.copyOf(this.residue);
    }

    public List<String> getWarnings() {
        return this.impl.getWarnings();
    }

    @Override
    public <O extends OptionsBase> O getOptions(Class<O> optionsClass) {
        return this.impl.getParsedOptions(optionsClass);
    }

    @Override
    public boolean containsExplicitOption(String name) {
        return this.impl.containsExplicitOption(name);
    }

    @Override
    public List<UnparsedOptionValueDescription> asListOfUnparsedOptions() {
        return this.impl.asListOfUnparsedOptions();
    }

    @Override
    public List<UnparsedOptionValueDescription> asListOfExplicitOptions() {
        return this.impl.asListOfExplicitOptions();
    }

    @Override
    public List<OptionValueDescription> asListOfEffectiveOptions() {
        return this.impl.asListOfEffectiveOptions();
    }

    @Override
    public List<String> canonicalize() {
        return this.impl.asCanonicalizedList();
    }

    static enum DocumentationLevel {
        DOCUMENTED,
        UNDOCUMENTED,
        HIDDEN;

    }

    public static enum HelpVerbosity {
        LONG,
        MEDIUM,
        SHORT;

    }

    public static class UnparsedOptionValueDescription {
        private final String name;
        private final Field field;
        private final String unparsedValue;
        private final OptionPriority priority;
        private final String source;
        private final boolean explicit;

        public UnparsedOptionValueDescription(String name, Field field, String unparsedValue, OptionPriority priority, String source, boolean explicit) {
            this.name = name;
            this.field = field;
            this.unparsedValue = unparsedValue;
            this.priority = priority;
            this.source = source;
            this.explicit = explicit;
        }

        public String getName() {
            return this.name;
        }

        Field getField() {
            return this.field;
        }

        public boolean isBooleanOption() {
            return this.field.getType().equals(Boolean.TYPE);
        }

        private DocumentationLevel documentationLevel() {
            Option option = this.field.getAnnotation(Option.class);
            return OptionsParser.documentationLevel(option.category());
        }

        public boolean isDocumented() {
            return this.documentationLevel() == DocumentationLevel.DOCUMENTED;
        }

        public boolean isHidden() {
            return this.documentationLevel() == DocumentationLevel.HIDDEN;
        }

        boolean isExpansion() {
            Option option = this.field.getAnnotation(Option.class);
            return option.expansion().length > 0;
        }

        boolean isImplicitRequirement() {
            Option option = this.field.getAnnotation(Option.class);
            return option.implicitRequirements().length > 0;
        }

        boolean allowMultiple() {
            Option option = this.field.getAnnotation(Option.class);
            return option.allowMultiple();
        }

        public String getUnparsedValue() {
            return this.unparsedValue;
        }

        OptionPriority getPriority() {
            return this.priority;
        }

        public String getSource() {
            return this.source;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("option '").append(this.name).append("' ");
            result.append("set to '").append(this.unparsedValue).append("' ");
            result.append("with priority ").append((Object)this.priority);
            if (this.source != null) {
                result.append(" and source '").append(this.source).append("'");
            }
            return result.toString();
        }
    }

    public static class OptionValueDescription {
        private final String name;
        private final Object value;
        private final OptionPriority priority;
        private final String source;
        private final String implicitDependant;
        private final String expandedFrom;

        public OptionValueDescription(String name, Object value, OptionPriority priority, String source, String implicitDependant, String expandedFrom) {
            this.name = name;
            this.value = value;
            this.priority = priority;
            this.source = source;
            this.implicitDependant = implicitDependant;
            this.expandedFrom = expandedFrom;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public OptionPriority getPriority() {
            return this.priority;
        }

        public String getSource() {
            return this.source;
        }

        public String getImplicitDependant() {
            return this.implicitDependant;
        }

        public boolean isImplicitDependency() {
            return this.implicitDependant != null;
        }

        public String getExpansionParent() {
            return this.expandedFrom;
        }

        public boolean isExpansion() {
            return this.expandedFrom != null;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("option '").append(this.name).append("' ");
            result.append("set to '").append(this.value).append("' ");
            result.append("with priority ").append((Object)this.priority);
            if (this.source != null) {
                result.append(" and source '").append(this.source).append("'");
            }
            if (this.implicitDependant != null) {
                result.append(" implicitly by ");
            }
            return result.toString();
        }
    }

    public static final class OptionDescription {
        private final String name;
        private final Object defaultValue;
        private final Converter<?> converter;
        private final boolean allowMultiple;

        public OptionDescription(String name, Object defaultValue, Converter<?> converter, boolean allowMultiple) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.converter = converter;
            this.allowMultiple = allowMultiple;
        }

        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Converter<?> getConverter() {
            return this.converter;
        }

        public boolean getAllowMultiple() {
            return this.allowMultiple;
        }
    }
}

