/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.DuplicateOptionDeclarationException;
import com.google.devtools.common.options.GenericTypeHelper;
import com.google.devtools.common.options.OpaqueOptionsData;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsParserImpl;
import com.google.devtools.common.options.OptionsParsingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
final class OptionsData
extends OpaqueOptionsData {
    private final Map<Class<? extends OptionsBase>, Constructor<?>> optionsClasses;
    private final Map<String, Field> nameToField;
    private final Map<Character, Field> abbrevToField;
    private final Map<Class<? extends OptionsBase>, List<Field>> allOptionsFields;
    private final Map<Field, Object> optionDefaults;
    private final Map<Field, Converter<?>> converters;
    private final Map<Field, Boolean> allowMultiple;

    private OptionsData(Map<Class<? extends OptionsBase>, Constructor<?>> optionsClasses, Map<String, Field> nameToField, Map<Character, Field> abbrevToField, Map<Class<? extends OptionsBase>, List<Field>> allOptionsFields, Map<Field, Object> optionDefaults, Map<Field, Converter<?>> converters, Map<Field, Boolean> allowMultiple) {
        this.optionsClasses = ImmutableMap.copyOf(optionsClasses);
        this.allOptionsFields = ImmutableMap.copyOf(allOptionsFields);
        this.nameToField = ImmutableMap.copyOf(nameToField);
        this.abbrevToField = ImmutableMap.copyOf(abbrevToField);
        this.optionDefaults = Collections.unmodifiableMap(optionDefaults);
        this.converters = ImmutableMap.copyOf(converters);
        this.allowMultiple = ImmutableMap.copyOf(allowMultiple);
    }

    public Collection<Class<? extends OptionsBase>> getOptionsClasses() {
        return this.optionsClasses.keySet();
    }

    public <T extends OptionsBase> Constructor<T> getConstructor(Class<T> clazz) {
        return this.optionsClasses.get(clazz);
    }

    public Field getFieldFromName(String name) {
        return this.nameToField.get(name);
    }

    public Iterable<Map.Entry<String, Field>> getAllNamedFields() {
        return this.nameToField.entrySet();
    }

    public Field getFieldForAbbrev(char abbrev) {
        return this.abbrevToField.get(Character.valueOf(abbrev));
    }

    public List<Field> getFieldsForClass(Class<? extends OptionsBase> optionsClass) {
        return this.allOptionsFields.get(optionsClass);
    }

    public Object getDefaultValue(Field field) {
        return this.optionDefaults.get(field);
    }

    public Converter<?> getConverter(Field field) {
        return this.converters.get(field);
    }

    public boolean getAllowMultiple(Field field) {
        return this.allowMultiple.get(field);
    }

    private static List<Field> getAllAnnotatedFields(Class<? extends OptionsBase> optionsClass) {
        ArrayList<Field> allFields = Lists.newArrayList();
        for (Field field : optionsClass.getFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            allFields.add(field);
        }
        if (allFields.isEmpty()) {
            throw new IllegalStateException(optionsClass + " has no public @Option-annotated fields");
        }
        return ImmutableList.copyOf(allFields);
    }

    private static Object retrieveDefaultFromAnnotation(Field optionField) {
        Object convertedValue;
        Converter<?> converter = OptionsParserImpl.findConverter(optionField);
        String defaultValueAsString = OptionsParserImpl.getDefaultOptionString(optionField);
        if (OptionsParserImpl.isSpecialNullDefault(defaultValueAsString, optionField)) {
            return null;
        }
        boolean allowsMultiple = optionField.getAnnotation(Option.class).allowMultiple();
        if (allowsMultiple) {
            return Collections.emptyList();
        }
        try {
            convertedValue = converter.convert(defaultValueAsString);
        }
        catch (OptionsParsingException e) {
            throw new IllegalStateException("OptionsParsingException while retrieving default for " + optionField.getName() + ": " + e.getMessage());
        }
        return convertedValue;
    }

    static OptionsData of(Collection<Class<? extends OptionsBase>> classes) {
        HashMap<Class<OptionsBase>, Constructor<?>> constructorBuilder = Maps.newHashMap();
        HashMap<Class<? extends OptionsBase>, List<Field>> allOptionsFieldsBuilder = Maps.newHashMap();
        HashMap<String, Field> nameToFieldBuilder = Maps.newHashMap();
        HashMap<Character, Field> abbrevToFieldBuilder = Maps.newHashMap();
        HashMap<Field, Object> optionDefaultsBuilder = Maps.newHashMap();
        HashMap<Field, Converter<?>> convertersBuilder = Maps.newHashMap();
        HashMap<Field, Boolean> allowMultipleBuilder = Maps.newHashMap();
        for (Class<? extends OptionsBase> parsedOptionsClass : classes) {
            try {
                Constructor<? extends OptionsBase> constructor = parsedOptionsClass.getConstructor(new Class[0]);
                constructorBuilder.put(parsedOptionsClass, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(parsedOptionsClass + " lacks an accessible default constructor");
            }
            List<Field> fields = OptionsData.getAllAnnotatedFields(parsedOptionsClass);
            allOptionsFieldsBuilder.put(parsedOptionsClass, fields);
            for (Field field : fields) {
                Type converterResultType;
                Class<Converter<Object>> converter;
                Option annotation = field.getAnnotation(Option.class);
                Type fieldType = field.getGenericType();
                if (annotation.allowMultiple()) {
                    if (!(fieldType instanceof ParameterizedType)) {
                        throw new AssertionError((Object)"Type of multiple occurrence option must be a List<...>");
                    }
                    ParameterizedType pfieldType = (ParameterizedType)fieldType;
                    if (pfieldType.getRawType() != List.class) {
                        throw new AssertionError((Object)"Type of multiple occurrence option must be a List<...>");
                    }
                    fieldType = pfieldType.getActualTypeArguments()[0];
                }
                if ((converter = annotation.converter()) == Converter.class) {
                    Converter<?> actualConverter = OptionsParserImpl.DEFAULT_CONVERTERS.get(fieldType);
                    if (actualConverter == null) {
                        throw new AssertionError((Object)("Cannot find converter for field of type " + field.getType() + " named " + field.getName() + " in class " + field.getDeclaringClass().getName()));
                    }
                    converter = actualConverter.getClass();
                }
                if (Modifier.isAbstract(converter.getModifiers())) {
                    throw new AssertionError((Object)("The converter type (" + converter + ") must be a concrete type"));
                }
                try {
                    Method convertMethod = converter.getMethod("convert", String.class);
                    converterResultType = GenericTypeHelper.getActualReturnType(converter, convertMethod);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)"A known converter object doesn't implement the convert method");
                }
                if (annotation.allowMultiple()) {
                    if (GenericTypeHelper.getRawType(converterResultType) == List.class) {
                        Type elementType = ((ParameterizedType)converterResultType).getActualTypeArguments()[0];
                        if (!GenericTypeHelper.isAssignableFrom(fieldType, elementType)) {
                            throw new AssertionError((Object)("If the converter return type of a multiple occurance option is a list, then the type of list elements (" + fieldType + ") must be assignable from the converter list element type (" + elementType + ")"));
                        }
                    } else if (!GenericTypeHelper.isAssignableFrom(fieldType, converterResultType)) {
                        throw new AssertionError((Object)("Type of list elements (" + fieldType + ") for multiple occurrence option must be assignable from the converter return type (" + converterResultType + ")"));
                    }
                } else if (!GenericTypeHelper.isAssignableFrom(fieldType, converterResultType)) {
                    throw new AssertionError((Object)("Type of field (" + fieldType + ") must be assignable from the converter return type (" + converterResultType + ")"));
                }
                if (annotation.name() == null) {
                    throw new AssertionError((Object)"Option cannot have a null name");
                }
                if (nameToFieldBuilder.put(annotation.name(), field) != null) {
                    throw new DuplicateOptionDeclarationException("Duplicate option name: --" + annotation.name());
                }
                if (!annotation.oldName().isEmpty() && nameToFieldBuilder.put(annotation.oldName(), field) != null) {
                    throw new DuplicateOptionDeclarationException("Old option name duplicates option name: --" + annotation.oldName());
                }
                if (annotation.abbrev() != '\u0000' && abbrevToFieldBuilder.put(Character.valueOf(annotation.abbrev()), field) != null) {
                    throw new DuplicateOptionDeclarationException("Duplicate option abbrev: -" + annotation.abbrev());
                }
                optionDefaultsBuilder.put(field, OptionsData.retrieveDefaultFromAnnotation(field));
                convertersBuilder.put(field, OptionsParserImpl.findConverter(field));
                allowMultipleBuilder.put(field, annotation.allowMultiple());
            }
        }
        return new OptionsData(constructorBuilder, nameToFieldBuilder, abbrevToFieldBuilder, allOptionsFieldsBuilder, optionDefaultsBuilder, convertersBuilder, allowMultipleBuilder);
    }
}

