/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

class GenericTypeHelper {
    @VisibleForTesting
    static Class<?> getRawType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        throw new AssertionError((Object)"A known concrete type is not concrete");
    }

    private static Type matchTypeVariable(Type type, TypeVariable<?> variable) {
        if (type instanceof ParameterizedType) {
            Class<?> rawInterfaceType = GenericTypeHelper.getRawType(type);
            TypeVariable<Class<?>>[] typeParameters = rawInterfaceType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!variable.equals(typeParameters[i])) continue;
                return ((ParameterizedType)type).getActualTypeArguments()[i];
            }
        }
        return null;
    }

    public static Type getActualReturnType(Type type, Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof Class) {
            return returnType;
        }
        if (returnType instanceof ParameterizedType) {
            return returnType;
        }
        if (returnType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)returnType;
            while (type != null) {
                Type candidate = GenericTypeHelper.matchTypeVariable(type, variable);
                if (candidate != null) {
                    return candidate;
                }
                Class<?> rawType = GenericTypeHelper.getRawType(type);
                for (Type interfaceType : rawType.getGenericInterfaces()) {
                    candidate = GenericTypeHelper.matchTypeVariable(interfaceType, variable);
                    if (candidate == null) continue;
                    return candidate;
                }
                type = rawType.getGenericSuperclass();
            }
        }
        throw new AssertionError((Object)("The type " + returnType + " is not a Class, ParameterizedType, or TypeVariable"));
    }

    public static boolean isAssignableFrom(Type to, Type from) {
        Class toClass;
        if (to instanceof Class && (toClass = (Class)to).isPrimitive()) {
            return Primitives.wrap(toClass).equals(from);
        }
        return TypeToken.of(to).isSupertypeOf(from);
    }

    private GenericTypeHelper() {
    }
}

