/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.devtools.common.options.Converters;
import com.google.devtools.common.options.EnumConverter;
import com.google.devtools.common.options.OptionsParsingException;

public abstract class BoolOrEnumConverter<T extends Enum<T>>
extends EnumConverter<T> {
    private T falseValue;
    private T trueValue;

    protected BoolOrEnumConverter(Class<T> enumType, String typeName, T trueValue, T falseValue) {
        super(enumType, typeName);
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public T convert(String input) throws OptionsParsingException {
        try {
            return (T)super.convert(input);
        }
        catch (OptionsParsingException eEnum) {
            try {
                Converters.BooleanConverter booleanConverter = new Converters.BooleanConverter();
                boolean value = booleanConverter.convert(input);
                return value ? this.trueValue : this.falseValue;
            }
            catch (OptionsParsingException eBoolean) {
                throw eEnum;
            }
        }
    }
}

